<?php
/**
 * Core user upload attachment class.
 *
 * @package CommunityAlly
 * @subpackage Core
 * @since 1.0.2
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * BP Attachment Avatar class.
 *
 * Extends BP Attachment to manage the avatar uploads.
 *
 * @since 2.3.0
 */
class BP_Attachment_User_Upload extends BP_Attachment {

	/**
	 * Construct Upload parameters.
	 *
	 * @since 2.3.0
	 *
	 * @see  BP_Attachment::__construct() for list of parameters
	 */
	public function __construct() {
		parent::__construct( array(
			'action'                => 'communityally_activity_upload_file',
			'file_input'            => 'file',
			'base_dir'              => bp_attachments_uploads_dir_get( 'dir' ),

			// Specific errors for avatars.
			'upload_error_strings'  => array(
			),
		) );
	}

	/**
	 * Avatar specific rules.
	 *
	 * Adds an error if the avatar size or type don't match BuddyPress needs.
	 * The error code is the index of $upload_error_strings.
	 *
	 * @since 2.3.0
	 *
	 * @param array $file the temporary file attributes (before it has been moved).
	 * @return array the file with extra errors if needed.
	 */
	public function validate_upload( $file = array() ) {
		// Bail if already an error.
		if ( ! empty( $file['error'] ) ) {
			return $file;
		}

		// Return with error code attached.
		return $file;
	}

	/**
	 * Set the directory when uploading a file.
	 *
	 * @since CommunityAlly 1.0.2
	 *
	 * @param array $upload_dir The original Uploads dir.
	 * @return array $value Upload data (path, url, basedir...).
	 */
	public function upload_dir_filter( $upload_dir = array() ) {
		return bp_attachments_user_file_upload_dir();
	}
}
