<?php
/**
 * Groups: Single group "Discussions" screen handler
 * Handle the display of a group's discussions page.
 *
 * This is loaded in 'bp_screens' action
 * @since CommunityAlly 1.2
 */

function groups_screen_group_discussion() {

	if ( ! bp_is_single_item() ) {
		return false;
	}

	/**
	 * Fires before the loading of a single group's page.
	 *
	 * @since 1.0.0
	 */
	do_action( 'groups_screen_group_discussion' );

	/**
	 * Filters the template to load for a single group's page.
	 *
	 * @since 1.0.0
	 *
	 * @param string $value Path to a single group's template to load.
	 */
	bp_core_load_template( apply_filters( 'groups_template_group_discussion', 'groups/single/discussion' ) );
}