<div id="buddypress" class="buddypress-wrap communityally-shortcode-element <?php echo esc_attr(get_template()); ?>">
<div id="communityally-wait-overlay">
	<div class="communityally-wait-animation">
		<div class="communityally-wait-circle"></div>
	</div>
</div>
<span id="communityally-back-button" style="display:none"><i class="bi bi-arrow-left"></i></span>

<?php
$group_cover_image_url = bp_attachments_get_attachment( 'url', array(
	'object_dir' => 'groups',
	'item_id'    => $group_id,
) );
?>

<div id="item-header" role="complementary" data-bp-item-id="<?php echo $group_id; ?>" data-bp-item-component="groups" class="groups-header single-headers">

	<div id="cover-image-container" class="communityally-header-image">
		<div id="header-cover-image" <?php echo empty($group_cover_image_url) ? 'class="communityally-default-header"' : ''; ?> >
			<h1 class="communityally-group-header-image-name">
				<?php bp_group_name($group) ?>
			</h1>
			<img class="communityally-header-cover-image" src="<?php echo empty($group_cover_image_url) ? '' : esc_attr($group_cover_image_url); ?>" />
		</div>
		<div id="item-header-cover-image">

				<div id="item-header-avatar">
					<?php
					if (shortcode_exists('accessally_icon')) {
						echo do_shortcode('[accessally_icon post_id="' . $post_id . '" hide_disable="always" ' .
							'width="150"]');
					}
					?>
				</div><!-- #item-header-avatar -->

		</div><!-- #item-header-cover-image -->
	</div><!-- #cover-image-container -->

	<div class="communityally-group-header-container">
		<div class="communityally-group-header-content">
			<h1 class="communityally-group-name"><?php bp_group_name($group) ?></h1>
	
			<?php
			$group_description = bp_get_group_description($group);
			if (!empty($group_description)) : ?>
				<div class="communityally-group-description">
					<?php echo $group_description; ?>
				</div><!-- //.group_description -->
			<?php endif; ?>
		</div>
		<div class="communityally-member-profile-items-container">
			<?php echo CommunityAlly_Members_Setup::generate_member_profile_item_shortcuts(false); ?>
		</div>
	</div>

</div><!-- #item-header -->

<div class="bp-wrap">

	<?php bp_get_template_part('groups/single/parts/item-nav', null, array('items' => $nav_items)); ?>

	<div id="item-body" class="item-body">

		<?php bp_nouveau_group_get_template_part($group_id, $subpage, $args); ?>

	</div><!-- #item-body -->

</div><!-- // .bp-wrap -->
</div><!-- // .buddypress -->

