<?php
/**
 * The BuddyPress Plugin.
 *
 * BuddyPress is social networking software with a twist from the creators of WordPress.
 *
 * @package BuddyPress
 * @subpackage Main
 * @since 1.0.0
 */

/**
 * Plugin Name: CommunityAlly
 * Plugin URI:  https://accessally.com/
 * Description: CommunityAlly brings community features to your AccessAlly membership site. Our Group, Member Profiles and Notifications allow you and your members to connect with each other effortlessly.
 * Author:      AccessAlly
 * Author URI:  https://accessally.com/
 * Version:     1.5.0
 * Text Domain: communityally
 * License:     GPLv2 or later (license.txt)
 */

/**
 * This files should always remain compatible with the minimum version of
 * PHP supported by WordPress.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// Required PHP version.
define( 'BP_REQUIRED_PHP_VERSION', '5.6.0' );

$active_plugins = array_merge(get_option('active_plugins'), get_site_option('active_sitewide_plugins', array()));
$active_plugins[] = isset( $_REQUEST['plugin'] ) ? $_REQUEST['plugin'] : array();
$is_buddypress_activated = in_array('buddypress/bp-loader.php', $active_plugins);
$is_buddyboss_activated = in_array('buddyboss-platform/bp-loader.php', $active_plugins);

if ( !$is_buddypress_activated && !$is_buddyboss_activated) {
	/**
	 * The main function responsible for returning the one true BuddyPress Instance to functions everywhere.
	 *
	 * Use this function like you would a global variable, except without needing
	 * to declare the global.
	 *
	 * Example: <?php $bp = buddypress(); ?>
	 *
	 * @return BuddyPress|null The one true BuddyPress Instance.
	 */
	function buddypress() {
		return BuddyPress::instance();
	}

	/**
	 * Adds an admin notice to installations that don't meet BP's minimum PHP requirement.
	 *
	 * @since 2.8.0
	 */
	function bp_php_requirements_notice() {
		if ( ! current_user_can( 'update_core' ) ) {
			return;
		}

		?>

		<div id="message" class="error notice is-dismissible">
			<p><strong><?php esc_html_e( 'Your site does not support BuddyPress.', 'buddypress' ); ?></strong></p>
			<?php /* translators: 1: current PHP version, 2: required PHP version */ ?>
			<p><?php printf( esc_html__( 'Your site is currently running PHP version %1$s, while BuddyPress requires version %2$s or greater.', 'buddypress' ), esc_html( phpversion() ), esc_html( BP_REQUIRED_PHP_VERSION ) ); ?> <?php printf( __( 'See <a href="%s">the Codex guide</a> for more information.', 'buddypress' ), 'https://codex.buddypress.org/getting-started/buddypress-2-8-will-require-php-5-3/' ); ?></p>
			<p><?php esc_html_e( 'Please update your server or deactivate BuddyPress.', 'buddypress' ); ?></p>
		</div>

		<?php
	}

	function communityally_load_textdomain() {
		$language_dir = basename(dirname(__FILE__)) . '/languages';
		load_plugin_textdomain('buddypress', false, $language_dir);
		load_plugin_textdomain('communityally', false, $language_dir);
	}

	if ( version_compare( phpversion(), BP_REQUIRED_PHP_VERSION, '<' ) ) {
		add_action( 'admin_notices', 'bp_php_requirements_notice' );
		add_action( 'network_admin_notices', 'bp_php_requirements_notice' );
		return;
	} else {
		require dirname( __FILE__ ) . '/class-buddypress.php';
		require_once('updater.php');

		/*
		 * Hook BuddyPress early onto the 'plugins_loaded' action.
		 *
		 * This gives all other plugins the chance to load before BuddyPress,
		 * to get their actions, filters, and overrides setup without
		 * BuddyPress being in the way.
		 */
		if ( defined( 'BUDDYPRESS_LATE_LOAD' ) ) {
			add_action( 'plugins_loaded', 'buddypress', (int) BUDDYPRESS_LATE_LOAD );

		// "And now here's something we hope you'll really like!".
		} else {
			$GLOBALS['bp'] = buddypress();
		}

		add_action('plugins_loaded', 'communityally_load_textdomain', 10);
	}
} else {
	function communityally_activation_conflict() {
		deactivate_plugins('communityally/bp-loader.php');

		?>
		<div id="message" class="error notice is-dismissible">
			<p>CommunityAlly is deactivated</p>
			<p>CommunityAlly is incompatible with BuddyPress and BuddyBoss Platform. Please deactivate them to continue using CommunityAlly</p>
		</div>
		<?php
	}

	add_action( 'admin_notices', 'communityally_activation_conflict' );
	add_action( 'network_admin_notices', 'communityally_activation_conflict' );
}

