<?php
$r = array(
	'user_id' => $display_user_id,
	'scope' => 'groups',
	'parent_id' => 0,
);
$selected_filter = 'active';
if (isset($args['group-order-by'])) {
	$r['type'] = $args['group-order-by'];
	$selected_filter = $args['group-order-by'];
}
if (isset($args['page'])) {
	$r['page'] = $args['page'];
}
?>

<div class="communityally-members-content-container communityally-members-groups-container communityally-shortcode-element" id="communityally-members-groups-container">
<div id="communityally-wait-overlay">
	<div class="communityally-wait-animation">
		<div class="communityally-wait-circle"></div>
	</div>
	<aside id="communityally-members-groups-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
</div>
<div class="communityally-member-groups-header-container">
	<h2 class="communityally-member-groups-title">
		<?php communityally_member_groups_title(); ?>
	</h2>
	<div class="subnav-filters filters clearfix no-subnav communityally-search-row">
		<div class="component-filters clearfix">
			<div class="last filter">
				<div class="select-wrap">
					<select communityally-members-group-filter="<?php echo $display_user_id; ?>">
						<option <?php selected($selected_filter, 'active'); ?> value="active"><?php echo esc_html__('Last Active', 'buddypress'); ?></option>
						<option <?php selected($selected_filter, 'popular'); ?> value="popular"><?php echo esc_html__('Most Members', 'buddypress'); ?></option>
						<option <?php selected($selected_filter, 'newest'); ?> value="newest"><?php echo esc_html__('Newly Created', 'buddypress'); ?></option>
						<option <?php selected($selected_filter, 'alphabetical'); ?> value="alphabetical"><?php echo esc_html__('Alphabetical', 'buddypress'); ?></option>
					</select>
					<span class="select-arrow" aria-hidden="true"></span>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="groups mygroups communityally-members-group-list" data-bp-list="groups">
<?php if (bp_has_groups($r)): ?>

	<ul id="groups-list" class="item-list groups-list bp-list grid three">

		<?php while ( bp_groups() ) : bp_the_group(); ?>

			<li <?php bp_group_class( array( 'item-entry' ) ); ?> data-bp-item-id="<?php bp_group_id(); ?>" data-bp-item-component="groups">
				<div class="list-wrap">
					<div class="item-avatar">
						<a href="<?php bp_group_permalink(); ?>"><?php bp_group_avatar( bp_nouveau_avatar_args() ); ?></a>
					</div>

					<div class="item">
						<div class="item-block">
							<h2 class="list-title groups-title"><?php bp_group_link(); ?></h2>

							<?php if ( bp_nouveau_group_has_meta() ) : ?>

								<p class="item-meta group-details"><?php bp_nouveau_the_group_meta( array( 'keys' => array( 'count' ) ) ); ?></p>

							<?php endif; ?>

							<p class="last-activity item-meta">
								<?php
									printf(
										/* translators: %s: last activity timestamp (e.g. "Active 1 hour ago") */
										esc_html__( 'Active %s', 'buddypress' ),
										sprintf(
											'<span data-livestamp="%1$s">%2$s</span>',
											bp_core_get_iso8601_date( bp_get_group_last_active( 0, array( 'relative' => false ) ) ),
											esc_html( bp_get_group_last_active() )
										)
									);
								?>
							</p>

						</div>
					</div>

				</div>

			</li>

		<?php endwhile; ?>

	</ul>

	<div class="bp-pagination bottom" data-bp-pagination="mlpage">
		<?php
		global $groups_template;
		$start_num = intval(($groups_template->pag_page - 1) * $groups_template->pag_num) + 1;
		$from_num = number_format_i18n($start_num);
		$to_num = number_format_i18n(min($start_num + ($groups_template->pag_num - 1), $groups_template->total_group_count));
		$total = number_format_i18n($groups_template->total_group_count);
		if (1 == $groups_template->total_group_count) {
			$message = __( 'Viewing 1 group', 'buddypress' );
		} else {
			/* translators: 1: group from number. 2: group to number. 3: total groups. */
			$message = sprintf(_n('Viewing %1$s - %2$s of %3$s group', 'Viewing %1$s - %2$s of %3$s groups', $groups_template->total_group_count, 'buddypress'),
				$from_num, $to_num, $total);
		}
		?>
		<div class="pag-count bottom">
			<p class="pag-data">
				<?php echo esc_html($message); ?>
			</p>
		</div>

		<?php
		$pagination_links = paginate_links(array(
			'base'      => '#%#%',
			'format'    => '',
			'total'     => ceil((int) $groups_template->total_group_count / (int) $groups_template->pag_num),
			'current'   => $groups_template->pag_page,
			'prev_text' => _x( '&larr;', 'Group pagination previous text', 'buddypress' ),
			'next_text' => _x( '&rarr;', 'Group pagination next text', 'buddypress' ),
			'mid_size'  => 1,
		));
		if (!empty($pagination_links)) :
		?>
			<div class="bp-pagination-links bottom" communityally-members-group-page-update="<?php echo $display_user_id; ?>">
				<p class="pag-data">
					<?php echo wp_kses_post($pagination_links); ?>
				</p>
			</div>
		<?php endif; ?>

	</div>

<?php else : ?>

	<aside class="bp-feedback bp-messages info">
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php esc_html_e('Sorry, there were no groups found.', 'buddypress'); ?></p>
	</aside>

<?php endif; ?>
</div>
</div>