<?php
$user_has_cover_image = bp_attachments_get_user_has_cover_image($display_user_id);
$user_cover_image_url = '';
if ($user_has_cover_image) {
	$user_cover_image_url = bp_attachments_get_attachment( 'url', array(
		'item_id'   => $display_user_id,
	) );
}
$display_name = bp_core_get_user_displayname($display_user_id);

$current_user_id = get_current_user_id();
?>
<div id="item-header" role="complementary" data-bp-item-component="members" class="users-header single-headers">
	<div id="cover-image-container" class="communityally-header-image">
		<div id="header-cover-image" <?php echo $user_has_cover_image ? '' : 'class="communityally-default-header"'; ?> >
			<h1 class="communityally-member-header-image-name">
				<?php echo esc_html(get_bloginfo( 'name' )); ?>
			</h1>
			<img class="communityally-header-cover-image" src="<?php echo empty($user_cover_image_url) ? '' : esc_attr($user_cover_image_url); ?>" />
		</div>
	</div><!-- #cover-image-container -->

	<div class="communityally-member-header-content">
		<div class="communityally-avatar-full-size">
			<?php bp_displayed_user_avatar( 'type=full&item_id=' . $display_user_id ); ?>
		</div>

		<h1 class="communityally-member-name">
			<?php echo esc_html($display_name); ?>
		</h1>
		<?php
		if ($display_user_id === $current_user_id){
			/* favourite, Inbox, Notification bell, Profile */
		?>
		<div class="communityally-member-profile-items-container">
			<?php echo CommunityAlly_Members_Setup::generate_member_profile_item_shortcuts($display_user_id); ?>
		</div>
		<?php
		} elseif (CommunityAllySettings::is_messaging_enabled()) { // check if message component is enabled
			/* message button */
			// do not show message button for self
			$send_private_message_url = CommunityAlly_Members_Setup::generate_send_private_message_url($display_user_id);
		?>
		<div id="send-private-message" class="generic-button">
			<a href="<?php echo esc_attr($send_private_message_url); ?>" class="send-message">
				<?php esc_html_e( 'Message', 'communityally' ); ?>
			</a>
		</div>
		<?php } ?>
	</div>
</div><!-- #item-header -->