<?php
list($user_nav_items, $subpage) = self::get_nav_items($display_user_id);
$favourite_link = isset($user_nav_items['activity']) ? $user_nav_items['activity']['url'] : '';
$profile_link = isset($user_nav_items['profile']) ? $user_nav_items['profile']['url'] : '';
$notification_link = isset($user_nav_items['notifications']) ? $user_nav_items['notifications']['url'] : '';
?>
<a class="communityally-member-profile-items communityally-member-profile-favourites" href="<?php echo esc_attr($favourite_link); ?>">
	<div class="communityally-member-profile-items-label"><?php echo esc_html_x('Favorites', 'Profile activity screen sub nav', 'buddypress'); ?></div>
</a>
<?php
/** Messages Shortcut */
if (CommunityAllySettings::is_messaging_enabled() && isset($user_nav_items['messages'])){
?>
<a class="communityally-member-profile-items communityally-member-profile-messages" href="<?php echo esc_attr($user_nav_items['messages']['url']); ?>">
	<div class="communityally-member-profile-items-label"><?php esc_html_e('Messages', 'buddypress'); ?></div>
</a>
<?php
}
?>
<a class="communityally-member-profile-items communityally-member-profile-notification" href="<?php echo esc_attr($notification_link); ?>">
	<?php
	$notification_count = $user_nav_items['notifications']['count'];
	if (!empty($notification_count)) {
	?>
		<span class="count communityally-notification-count"><?php echo $notification_count; ?></span>
	<?php
	}
	?>
	<div class="communityally-member-profile-items-label"><?php esc_html_e('Notifications', 'buddypress'); ?></div>
</a>
<a class="communityally-member-profile-items communityally-member-profile-shortcut" href="<?php echo esc_attr($profile_link); ?>">
	<?php bp_displayed_user_avatar( 'item_id=' . $display_user_id ); ?>
	<div class="communityally-member-profile-items-label"><?php echo esc_html_x('Profile', 'Member profile main navigation', 'buddypress'); ?></div>
</a>