<div class="communityally-members-content-container communityally-members-messages-container communityally-shortcode-element" id="communityally-members-messages-container">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<aside id="communityally-members-messages-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
	<div class="bp-messages-content">
		<form class="standard-form" communityally-send-private-message-form="<?php echo esc_attr(wp_create_nonce('communityally-send-private-message')); ?>">
			<div class="communityally-send-to-container">
				<label for="send-to-input"><?php esc_html_e( 'To:', 'buddypress' ); ?></label>
				<div class="communityally-message-compose-sent-to-container">
					<?php
					if (!empty($_REQUEST[CommunityAlly_Members_Setup::SEND_TO_ARG])) {
						$send_to_val = $_REQUEST[CommunityAlly_Members_Setup::SEND_TO_ARG];
						$send_to_list = explode('|', $send_to_val);
						foreach ($send_to_list as $user_arg) {
							$user_id = apply_filters('accessally_get_decrypted_user_id', $user_arg, 'communityally');
							if ($user_id > 0) {
								$userdata = get_userdata($user_id);
								if (!empty($userdata)) {
									$image_url = bp_core_fetch_avatar( array( 'html' => false, 'item_id' => $user_id) );
									?>
					<div class="communityally-message-recipient-entry">
						<img src="<?php echo esc_attr($image_url); ?>" />
						<span class="communityally-message-recipient-name"><?php echo esc_html($userdata->display_name); ?></span>
						<input name="recipient[]" type="hidden" value="<?php echo $user_id; ?>" />
						<div class="communityally-message-recipient-delete"></div>
					</div>
									<?php
								}
							}
						}
					}
					?>
					<input type="text" class="communityally-name-trigger-suggestions" id="send-to-input" size="40"
						   placeholder="<?php esc_html_e('Recipients', 'buddypress'); ?>" />
				</div>
			</div>

			<div class="communityally-send-to-container">
				<label for="subject"><?php esc_html_e('Subject', 'buddypress'); ?></label>
				<input type="text" name="subject" id="subject" />
			</div>

			<div id="bp-message-content">
				<?php
				wp_editor(
					'',
					'message_content',
					array(
						'textarea_name' => 'message_content',
						'teeny'         => false,
						'media_buttons' => false,
						'dfw'           => false,
						'tinymce'       => array(
							'toolbar1' => 'bold,italic,bullist,blockquote,link',
							'init_instance_callback' => 'window.bp.mentions.tinyMCEinit',
							),
						'quicktags'     => false,
						'tabindex'      => '3',
						'textarea_rows' => 5,
					)
				);
				?>
			</div>

			<div class="submit">
				<input type="submit" id="bp-messages-send" class="button communityally-button communityally-activity-submit-button"
					   value="<?php echo esc_attr_x( 'Send', 'button', 'buddypress' ); ?>"/>
				<input type="reset" id="bp-messages-reset" class="text-button small communityally-activity-reset-button"
					   value="<?php echo esc_attr_x( 'Reset', 'form reset button', 'buddypress' ); ?>"/>
			</div>
		</form>
	</div>
</div>