<?php
global $thread_template;
$thread = false;
if (messages_is_valid_thread($thread_id) && messages_check_thread_access($thread_id, $current_user_id)) {
	if (bp_thread_has_messages(array('thread_id' => $thread_id))) {
		$thread = $thread_template->thread;
	}
	messages_mark_thread_read($thread_id);
}
?>

<div class="communityally-members-content-container communityally-members-messages-container communityally-shortcode-element" id="communityally-members-messages-container">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<aside id="communityally-members-messages-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
<?php if (false !== $thread) : ?>
	<div class="bp-messages-content">
		<div id="bp-message-thread-header" class="message-thread-header">
			<h2 id="message-subject" class="message-title single-thread-title">
				<?php
				$subject = $thread->last_message_subject;
				$subject = wp_filter_kses($subject);
				$subject = stripslashes_deep($subject);
				echo esc_html($subject);
				?>
			</h2>
			<header class="communityally-single-message-thread-header">
				<dl class="thread-participants">
					<dt><?php esc_html_e( 'Participants:', 'buddypress' ); ?></dt>
					<dd>
						<ul class="participants-list">
							<?php
							foreach ($thread->recipients as $recipient) {
								$user_link = CommunityAlly_Members_Setup::get_members_page_url('profile', $recipient->user_id);
								$display_name = bp_core_get_user_displayname($recipient->user_id);	// the value is already escaped
								$avatar_url = bp_core_fetch_avatar(array(
									'item_id' => $recipient->user_id,
									'object'  => 'user',
									'type'    => 'thumb',
									'width'   => 28,
									'height'  => 28,
									'html'    => false,
								));
							?>
							<li>
								<a href="<?php echo esc_attr($user_link); ?>" class="bp-tooltip" target="_blank" data-bp-tooltip="<?php echo $display_name; ?>">
									<img class="avatar mini" src="<?php echo esc_attr($avatar_url); ?>" alt="<?php echo $display_name; ?>">
								</a>
							</li>
							<?php } ?>
						</ul>
					</dd>
				</dl>

				<div type="button" class="communityally-message-action-delete dashicons dashicons-trash"
					 communityally-messages-delete-reply-thread="<?php echo esc_attr($thread_id . '|' . wp_create_nonce('communityally-delete-private-message-' . $thread_id)); ?>">
					<span class="bp-screen-reader-text"><?php esc_html_e('Delete conversation.', 'buddypress'); ?></span>
				</div>
			</header>
		</div>
		<ul id="bp-message-thread-list">
			<?php
			while ( bp_thread_messages() ) :
				$message = bp_thread_the_message();
				$message_id = $message->id;
				$sender_user_id = $message->sender_id;
				$sender_link = CommunityAlly_Members_Setup::get_members_page_url('profile', $sender_user_id);
				$sender_name = bp_core_get_user_displayname($sender_user_id);	// the value is already escaped
				$sender_avatar_url = bp_core_fetch_avatar(array(
						'item_id' => $sender_user_id,
						'object'  => 'user',
						'type'    => 'thumb',
						'width'   => 32,
						'height'  => 32,
						'html'    => false,
					));
				$send_date = strtotime($message->date_sent);
				$display_send_date = sprintf(
					/* translators: %s: last activity timestamp (e.g. "active 1 hour ago") */
					__( 'Sent %s', 'buddypress' ),
					bp_core_time_since($send_date)
				);

				$is_starred = bp_messages_is_message_starred($message_id, $display_user_id);

				$content = communityallly_activity_generate_mention_links($message->message);
			?>
			<li>
				<div class="message-metadata">
					<a href="<?php echo esc_attr($sender_link); ?>" class="user-link" target="_blank">
						<img class="avatar" src="<?php echo esc_attr($sender_avatar_url); ?>" alt="" />
						<strong><?php echo $sender_name; ?></strong>
					</a>

					<time datetime="<?php echo esc_attr($message->date_sent); ?>" class="activity"><?php echo esc_html($display_send_date); ?></time>
					<div class="actions">
						<input type="hidden" communityally-data-dependency-source="messages-starred-message-<?php echo $message_id; ?>"
							   class="communityally-messages-is-starred-message-<?php echo $message_id; ?>"
							   value="<?php echo $is_starred ? 'yes' : 'no'; ?>" />
						<div class="message-action-star bp-tooltip bp-icons communityally-messages-icon-action" communityally-messages-add-star="message-<?php echo $message_id; ?>"
							<?php echo $is_starred ? 'style="display:none"' : ''; ?>
							 hide-toggle communityally-data-dependency="messages-starred-message-<?php echo $message_id; ?>" communityally-data-dependency-value="no"
							 data-bp-tooltip="<?php esc_html_e('Star Conversation', 'buddypress'); ?>">
							<span class="bp-screen-reader-text"><?php esc_html_e('Star Conversation', 'buddypress'); ?></span>
						</div>
						<div class="message-action-unstar bp-tooltip bp-icons communityally-messages-icon-action" communityally-messages-remove-star="message-<?php echo $message_id; ?>"
							<?php echo $is_starred ? '' : 'style="display:none"'; ?>
							 hide-toggle communityally-data-dependency="messages-starred-message-<?php echo $message_id; ?>" communityally-data-dependency-value="yes"
							 data-bp-tooltip="<?php esc_html_e('Unstar Conversation', 'buddypress'); ?>">
							<span class="bp-screen-reader-text"><?php esc_html_e('Unstar Conversation', 'buddypress'); ?></span>
						</div>
					</div>
				</div>
				<div class="message-content"><?php echo do_shortcode($content); ?></div>
			</li>
			<?php endwhile; ?>
		</ul>
		<?php
		$current_user_avatar_url = bp_core_fetch_avatar(array(
				'item_id' => $current_user_id,
				'object'  => 'user',
				'type'    => 'thumb',
				'width'   => 30,
				'height'  => 30,
				'html'    => false,
			));
		?>
		<form id="send-reply" class="standard-form send-reply"
			  communityally-private-message-reply-form="<?php echo esc_attr($thread_id . '|' . wp_create_nonce('communityally-reply-private-message-' . $thread_id)); ?>">
			<div class="message-box">
				<div class="message-metadata">
					<div class="avatar-box">
						<img class="avatar" src="<?php echo esc_attr($current_user_avatar_url); ?>" alt=""
							 width="30" height="30" />
						<strong><?php esc_html_e('Send a Reply', 'buddypress'); ?></strong>
					</div>
				</div><!-- .message-metadata -->
				<div class="message-content">
					<label for="message_content" class="bp-screen-reader-text"><?php _e('Reply to Message', 'buddypress'); ?></label>
					<div id="bp-message-content">
						<?php
						wp_editor(
							'',
							'message_content',
							array(
								'textarea_name' => 'message_content',
								'teeny'         => false,
								'media_buttons' => false,
								'dfw'           => false,
								'tinymce'       => array(
									'toolbar1' => 'bold,italic,bullist,blockquote,link',
									'init_instance_callback' => 'window.bp.mentions.tinyMCEinit',
									),
								'quicktags'     => false,
								'tabindex'      => '3',
								'textarea_rows' => 5,
							)
						);
						?>
					</div>
					<div class="submit">
						<input type="submit" name="send" class="communityally-private-message-compose-submit" value="<?php echo esc_attr_x('Send Reply', 'button', 'buddypress'); ?>" />
					</div>
				</div><!-- .message-content -->
			</div><!-- .message-box -->
		</form>
	</div>

<?php else : ?>

	<aside class="bp-feedback bp-messages info">
		<span class="bp-icon" aria-hidden="true"></span>
		<p>
			<?php esc_html_e('Sorry, no messages were found.', 'buddypress'); ?>
		</p>
	</aside>

<?php endif; ?>
</div>