<?php
$r = array(
	'user_id' => $display_user_id,
	'box' => 'sentbox',
);
if (isset($args['page'])) {
	$r['page'] = $args['page'];
}
$search_terms = '';
if (isset($args['search_terms'])) {
	$search_terms = $args['search_terms'];
	$r['search_terms'] = $search_terms;
}
?>

<div class="communityally-members-content-container communityally-members-messages-container communityally-shortcode-element" id="communityally-members-messages-container">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<aside id="communityally-members-messages-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
	<div class="communityally-messages-actions-container">
		<div class="communityally-messages-bulk-select-all-container">
			<label class="communityally-checkbox-container" class="bulk-select-all">
				<input type="checkbox" class="communityally-checkbox-input" communityally-bulk-select-all="messages" />
				<span class="communityally-checkbox-icon"></span>
			</label>
		</div>
		<div class="communityally-messages-bulk-manage-container" communityally-bulk-operation="messages" style="display:none">
			<div class="select-wrap">
				<label class="bp-screen-reader-text" for="communityally-messages-bulk-select">
					<?php esc_html_e('Select Bulk Action', 'buddypress'); ?>
				</label>

				<select name="messages_bulk_action" communityally-bulk-select="messages"
						id="communityally-messages-bulk-select" class="communityally-bulk-select">
					<option value="" selected="selected"><?php esc_html_e('Bulk Actions', 'buddypress'); ?></option>
					<option value="read"><?php esc_html_e('Mark read', 'buddypress'); ?></option>
					<option value="unread"><?php esc_html_e('Mark unread', 'buddypress'); ?></option>
					<option value="delete"><?php echo esc_html_x('Delete', 'button', 'buddypress'); ?></option>
					<option value="add-star"><?php esc_html_e('Add star', 'buddypress'); ?></option>
					<option value="remove-star"><?php esc_html_e('Remove star', 'buddypress'); ?></option>
				</select>

				<span class="select-arrow"></span>
			</div><!-- // .select-wrap -->

			<input type="button" communityally-bulk-submit="messages" class="button action communityally-bulk-operation-submit-button"
				   communityall-messages-bulk-submit="messages" style="display:none"
				   value="<?php echo esc_attr_x('Apply', 'button', 'buddypress' ); ?>">
		</div>
		<div class="bp-search messages-search">
			<form action="" method="get" id="user_messages_search_form" class="bp-messages-search-form" communityally-members-messages-page-update="sent">
				<label for="user_messages_search" class="bp-screen-reader-text">
					<?php esc_html_e('Search Messages', 'buddypress'); ?>
				</label>
				<input type="search" id="user_messages_search" class="communityally-search" name="search" value="<?php echo esc_attr($search_terms); ?>"
					   placeholder="<?php echo esc_attr_x('Search', 'search placeholder text', 'buddypress'); ?>" />
				<button type="submit" id="user_messages_search_submit" class="communityally-search-submit">
					<span class="dashicons dashicons-search" aria-hidden="true"></span>
					<span class="bp-screen-reader-text"><?php echo esc_html_x('Search', 'button', 'buddypress'); ?></span>
				</button>
			</form>
		</div>
		<?php communityally_get_compose_button(); ?>
	</div>
<?php
if (bp_has_message_threads($r)) : ?>
	<div id="notifications-bulk-management" class="communityally-sortable-parent">
		<div class="communityally-messages-container bp-messages-content">
			<table class="bp-tables-user">
				<tbody class="communityally-sortable-container">

					<?php
					while ( bp_message_threads() ) :
						$message_thread = bp_message_thread();

						$thread_id = $message_thread->thread_id;
						$subject = strip_tags($message_thread->last_message_subject);
						$content = communityallly_activity_generate_mention_links($message_thread->last_message_content);
						$excerpt = strip_tags(bp_create_excerpt($content, 75));

						$first_recipient = reset($message_thread->recipients);
						$first_recipient_user_id = $first_recipient->user_id;
						$first_recipient_avatar = bp_core_fetch_avatar(array(
								'item_id' => $first_recipient_user_id,
								'object'  => 'user',
								'type'    => 'thumb',
								'width'   => 28,
								'height'  => 28,
								'html'    => false,
							));
						$first_recipient_display_name = bp_core_get_user_displayname($first_recipient_user_id);
						$num_recipient = count($message_thread->recipients);

						$sent_date = bp_nouveau_get_message_date($message_thread->last_message_date);

						$is_starred = false;
						foreach ($message_thread->messages as $message) {
							// Try to find the first msg that is starred in a thread.
							if (bp_messages_is_message_starred($message->id, $display_user_id)) {
								$is_starred = true;
								break;
							}
						}
						$has_unread = $message_thread->unread_count > 0;

						$thread_url = CommunityAlly_Members_Setup::get_private_message_reply_url($thread_id);
						$esc_thread_url = esc_attr($thread_url);
					?>
						<tr class="communityally-messages-row-<?php echo $thread_id; ?> <?php echo $has_unread ? 'unread' : ''; ?>"
							communityally-messages-open="<?php echo $esc_thread_url; ?>">
							<td class="communityally-messages-checkbox-col bulk-select-check communityally-messages-click-to-open-strict">
								<label for="communityally-bulk-select-checkbox-<?php echo $thread_id; ?>" class="communityally-checkbox-container">
									<input id="communityally-bulk-select-checkbox-<?php echo $thread_id; ?>" type="checkbox"
										   communityally-individual-checkbox="messages"
										   value="<?php echo $thread_id; ?>" class="communityally-checkbox-input">
									<span class="communityally-checkbox-icon"></span>
								</label>
							</td>
							<td class="communityally-messages-star-col communityally-messages-click-to-open-strict">
								<input type="hidden" communityally-data-dependency-source="messages-starred-<?php echo $thread_id; ?>"
									   class="communityally-messages-is-starred-<?php echo $thread_id; ?>"
									   value="<?php echo $is_starred ? 'yes' : 'no'; ?>" />
								<div class="message-action-star bp-tooltip bp-icons communityally-messages-icon-action" communityally-messages-add-star="<?php echo $thread_id; ?>"
									<?php echo $is_starred ? 'style="display:none"' : ''; ?>
									 hide-toggle communityally-data-dependency="messages-starred-<?php echo $thread_id; ?>" communityally-data-dependency-value="no"
									 data-bp-tooltip="<?php esc_html_e('Star Conversation', 'buddypress'); ?>">
									<span class="bp-screen-reader-text"><?php esc_html_e('Star Conversation', 'buddypress'); ?></span>
								</div>
								<div class="message-action-unstar bp-tooltip bp-icons communityally-messages-icon-action" communityally-messages-remove-star="<?php echo $thread_id; ?>"
									<?php echo $is_starred ? '' : 'style="display:none"'; ?>
									 hide-toggle communityally-data-dependency="messages-starred-<?php echo $thread_id; ?>" communityally-data-dependency-value="yes"
									 data-bp-tooltip="<?php esc_html_e('Unstar Conversation', 'buddypress'); ?>">
									<span class="bp-screen-reader-text"><?php esc_html_e('Unstar Conversation', 'buddypress'); ?></span>
								</div>
							</td>
							<td class="communityally-messages-recipient-col communityally-messages-click-to-open">
								<div class="thread-to user-link">
									<img class="avatar" src="<?php echo esc_attr($first_recipient_avatar); ?>" alt="" />
									<span class="bp-screen-reader-text"><?php esc_html_e('To:', 'buddypress'); ?></span>
									<span>
										<span class="user-name"><?php echo esc_html($first_recipient_display_name); ?></span>
										<?php if ($num_recipient > 2) { ?>
											<span class="num-recipients"><?php echo esc_html(sprintf(__('(and %d others)', 'buddypress'), $num_recipient - 1)); ?></span>
										<?php } ?>
									</span>
								</div>
							</td>
							<td class="communityally-messages-subject-col communityally-messages-click-to-open">
								<?php echo esc_html($subject); ?>
								<div class="communityally-messages-excerpt"><?php echo esc_html($excerpt); ?></div>
							</td>
							<td class="communityally-messages-date-col communityally-messages-click-to-open"><?php echo esc_html($sent_date); ?></td>
						</tr>

					<?php endwhile; ?>

				</tbody>
			</table>
		</div>
	</div>

	<div class="bp-pagination bottom" data-bp-pagination="mlpage">
		<?php
		global $messages_template;
		$threads       = new stdClass;
		$threads->meta = array(
			'total_page' => ceil( (int) $messages_template->total_thread_count / (int) $messages_template->pag_num ),
			'page'       => $messages_template->pag_page,
		);

		$start_num = intval(($messages_template->pag_page - 1) * $messages_template->pag_num) + 1;
		$from_num = number_format_i18n($start_num);
		$to_num = number_format_i18n(min($start_num + ($messages_template->pag_num - 1), $messages_template->total_thread_count));
		$total = number_format_i18n($messages_template->total_thread_count);

		$total_pages = ceil((int)$messages_template->total_thread_count / (int)$messages_template->pag_num);

		if ($messages_template->total_thread_count > 1) {
			/* translators: 1: message from number. 2: message to number. 3: total messages. */
			$message = sprintf(_n('Viewing %1$s - %2$s of %3$s message', 'Viewing %1$s - %2$s of %3$s messages',
				$messages_template->total_thread_count, 'buddypress'), $from_num, $to_num, $total);
		} else {
			$message = __('Viewing 1 message', 'buddypress');
		}
		?>
		<div class="pag-count bottom">
			<p class="pag-data">
				<?php echo esc_html($message); ?>
			</p>
		</div>

		<?php
		$pagination_links = paginate_links( array(
				'base'      => '#%#%',
				'format'    => '',
				'total'     => $total_pages,
				'current'   => $messages_template->pag_page,
				'prev_text' => _x('&larr;', 'Message pagination previous text', 'buddypress'),
				'next_text' => _x('&rarr;', 'Message pagination next text', 'buddypress'),
				'mid_size'  => 1,
			) );
		if (!empty($pagination_links)) :
		?>
			<div class="bp-pagination-links bottom" communityally-members-messages-page-update="sent">
				<p class="pag-data">
					<?php echo wp_kses_post($pagination_links); ?>
				</p>
			</div>
		<?php endif; ?>
	</div>

<?php else : ?>

	<aside class="bp-feedback bp-messages info">
		<span class="bp-icon" aria-hidden="true"></span>
		<p>
			<?php esc_html_e('Sorry, no messages were found.', 'buddypress'); ?>
		</p>
	</aside>

<?php endif; ?>
</div>
