<?php
$r = array(
	'user_id' => $display_user_id,
	'scope' => 'notifications',
);
if (isset($args['page'])) {
	$r['page'] = $args['page'];
}
$link = bp_get_notifications_read_permalink($display_user_id);
?>

<div class="communityally-members-content-container communityally-members-notification-container communityally-shortcode-element" id="communityally-members-notification-container">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<aside id="communityally-members-notification-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
<?php
if (bp_has_notifications($r, false)) : ?>
	<div id="notifications-bulk-management" class="communityally-notification-element communityally-sortable-parent">
		<div class="communityally-notifications-container">
			<div class="communityally-notifications-type">
				<?php esc_html_e('Read', 'buddypress'); ?>
			</div>
			<table class="notifications bp-tables-user">
				<thead>
					<tr>
						<th class="icon"></th>
						<th class="bulk-select-all">
							<label class="communityally-checkbox-container">
								<input type="checkbox" class="select-all-notifications communityally-checkbox-input" />
								<span class="communityally-checkbox-icon"></span>
							</label>
						</th>
						<th class="title"><?php esc_html_e('Notifications', 'buddypress'); ?></th>
						<th class="date">
							<?php esc_html_e('Date Received', 'buddypress'); ?>
							<span class="notifications-order-actions">
								<a href="#" aria-label="<?php esc_attr_e('Newest First', 'buddypress'); ?>" style="display:none"
								   data-bp-notifications-order="DESC"><span class="dashicons dashicons-arrow-down" aria-hidden="true"></span></a>
								<a href="#" aria-label="<?php esc_attr_e('Oldest First', 'buddypress'); ?>"
								   data-bp-notifications-order="ASC"><span class="dashicons dashicons-arrow-up" aria-hidden="true"></span></a>
							</span>
						</th>
						<th class="actions"><?php esc_html_e('Actions', 'buddypress'); ?></th>
					</tr>
				</thead>

				<tbody class="communityally-sortable-container">

					<?php
					while ( bp_the_notifications() ) :
						bp_the_notification();

						$notification = buddypress()->notifications->query_loop->notification;
						$notification_id = $notification->id;
						$notified_date = $notification->date_notified;
						$notified_since = bp_core_time_since($notified_date);
					?>
						<tr class="communityally-notification-row-<?php echo $notification_id; ?>" communityally-sortable-entry="<?php echo esc_attr($notified_date); ?>">
							<td></td>
							<td class="bulk-select-check">
								<label for="communityally-notification-checkbox-<?php echo $notification_id; ?>" class="communityally-checkbox-container">
									<input id="communityally-notification-checkbox-<?php echo $notification_id; ?>" type="checkbox" value="<?php echo $notification_id; ?>" class="notification-check communityally-checkbox-input">
									<span class="communityally-checkbox-icon"></span>
								</label>
							</td>
							<td class="notification-description">
								<?php echo CommunityAlly_Members_Setup::generate_notification_description($notification);  ?>
							</td>
							<td class="notification-since"><?php echo esc_html($notified_since); ?></td>
							<td class="notification-actions">
								<a href="#" communityally-notification-mark-unread="<?php echo $notification_id; ?>" class="mark-read primary communityally-single-notification-action">
									<span class="dashicons dashicons-hidden" aria-hidden="true"></span>
									<span class="bp-screen-reader-text"><?php esc_html_e('Unread', 'buddypress'); ?></span>
								</a>
								|
								<a href="#" communityally-notification-delete="<?php echo $notification_id; ?>"
								   class="delete secondary confirm communityally-single-notification-action">
									<span class="dashicons dashicons-trash" aria-hidden="true"></span>
									<span class="bp-screen-reader-text"><?php esc_html_e('Delete', 'buddypress'); ?></span>
								</a>
							</td>
						</tr>

					<?php endwhile; ?>

				</tbody>
			</table>
		</div>
		<div class="communityally-notifications-bulk-manage-container notifications-options-nav">
			<div class="select-wrap">
				<label class="bp-screen-reader-text" for="notification-select">
					<?php esc_html_e('Select Bulk Action', 'buddypress'); ?>
				</label>

				<select name="notification_bulk_action" id="notification-select" class="notification-select" communityally-notification-type="read">
					<option value="" selected="selected"><?php esc_html_e('Bulk Actions', 'buddypress'); ?></option>
					<option value="unread"><?php echo esc_html_x('Mark unread', 'button', 'buddypress'); ?></option>
					<option value="delete"><?php echo esc_html_x('Delete', 'button', 'buddypress'); ?></option>
				</select>

				<span class="select-arrow"></span>
			</div><!-- // .select-wrap -->

			<input type="button" id="notification-bulk-manage" disabled="disabled" class="button action" value="<?php echo esc_attr_x('Apply', 'button', 'buddypress' ); ?>">
		</div><!-- .notifications-options-nav -->
	</div>

	<div class="bp-pagination bottom" data-bp-pagination="mlpage">
		<?php
		$query_loop = buddypress()->notifications->query_loop;
		$start_num = intval(($query_loop->pag_page - 1) * $query_loop->pag_num) + 1;
		$from_num = number_format_i18n( $start_num );
		$to_num = number_format_i18n(min($start_num + ($query_loop->pag_num - 1), $query_loop->total_notification_count));
		$total = number_format_i18n($query_loop->total_notification_count);

		if ( 1 == $query_loop->total_notification_count ) {
			$message = __('Viewing 1 notification', 'buddypress');
		} else {
			/* translators: 1: notification from number. 2: notification to number. 3: total notifications. */
			$message = sprintf(_n('Viewing %1$s - %2$s of %3$s notification', 'Viewing %1$s - %2$s of %3$s notifications',
				$query_loop->total_notification_count, 'buddypress'), $from_num, $to_num, $total);
		}
		?>
		<div class="pag-count bottom">
			<p class="pag-data">
				<?php echo esc_html($message); ?>
			</p>
		</div>

		<?php
		$pagination_links = paginate_links( array(
				'base'      => '#%#%',
				'format'    => '',
				'total'     => ceil((int) $query_loop->total_notification_count / (int) $query_loop->pag_num),
				'current'   => $query_loop->pag_page,
				'prev_text' => _x('&larr;', 'Notifications pagination previous text', 'buddypress'),
				'next_text' => _x('&rarr;', 'Notifications pagination next text', 'buddypress'),
				'mid_size'  => 1,
			) );
		if (!empty($pagination_links)) :
		?>
			<div class="bp-pagination-links bottom" communityally-members-notification-read-page-update="<?php echo $display_user_id; ?>">
				<p class="pag-data">
					<?php echo wp_kses_post($pagination_links); ?>
				</p>
			</div>
		<?php endif; ?>
	</div>

<?php else : ?>

	<aside class="bp-feedback bp-messages info">
		<span class="bp-icon" aria-hidden="true"></span>
		<p>
			<?php
			if ($display_user_id === $current_user_id) {
				esc_html_e('You have no notifications.', 'buddypress');
			} else {
				esc_html_e('This member has no notifications.', 'buddypress');
			}
			?>
		</p>
	</aside>

<?php endif; ?>
</div>
