<?php
$mention = bp_get_user_meta($display_user_id, 'notification_activity_new_mention', true);
if (!$mention) {
	$mention = 'yes';
}
$mention_web = bp_get_user_meta($display_user_id, 'notification_activity_new_mention_web', true);
if (!$mention_web) {
	$mention_web = 'yes';
}
$reply = bp_get_user_meta($display_user_id, 'notification_activity_new_reply', true);
if (!$reply) {
	$reply = 'yes';
}
$reply_web = bp_get_user_meta($display_user_id, 'notification_activity_new_reply_web', true);
if (!$reply_web) {
	$reply_web = 'yes';
}
$private_message_email = bp_get_user_meta($display_user_id, 'notification_messages_new_message', true);
if (!$private_message_email) {
	$private_message_email = 'yes';
}
$private_message_web = bp_get_user_meta($display_user_id, 'notification_messages_new_message_web', true);
if (!$private_message_web) {
	$private_message_web = 'yes';
}
$has_cover_image = bp_attachments_get_user_has_cover_image($display_user_id);
$selected_tab = 'cover-image';
if (!empty($args['selected-tab'])) {
	$selected_tab = $args['selected-tab'];
}
?>
<div id="communityally-members-settings-container">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<aside id="communityally-members-settings-error-message" class="bp-feedback bp-messages bp-template-notice success" <?php echo empty($args['notice']) ? 'style="display:none"' : ''; ?>>
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php echo empty($args['notice']) ? '' : esc_html($args['notice']); ?></p>
	</aside>
	<div class="communityally-member-setting-content-container communityally-shortcode-element">
		<nav class="bp-navs bp-subnavs no-ajax user-subnav communityally-member-profile-setting-nav" id="subnav" role="navigation" aria-label="<?php esc_attr_e( 'Settings menu', 'buddypress' ); ?>">
			<ul class="subnav">
				<li id="change-profile-banner-personal-li" class="bp-personal-sub-tab <?php echo 'cover-image' ===  $selected_tab ? 'current' : ''; ?>"
					communityally-tab-group="communityally-members-settings" communityally-target="cover-image" communityally-active-class="current">
					<a href="#" id="change-profile-banner">
						<?php esc_html_e('Cover Image', 'buddypress'); ?>
					</a>
				</li>
				<li id="notifications-personal-li" class="bp-personal-sub-tab <?php echo 'notifications' === $selected_tab ? 'current' : ''; ?>"
					communityally-tab-group="communityally-members-settings" communityally-target="notifications" communityally-active-class="current">
					<a href="#" id="change-profile-banner">
						<?php esc_html_e('Notification Preferences', 'communityally'); ?>
					</a>
				</li>
			</ul>
		</nav>
		<div class="communityally-member-profile-setting-content-container">
			<div class="communityally-member-profile-cover-image-container" communityally-members-settings="cover-image"
				<?php echo 'cover-image' ===  $selected_tab ? '' : 'style="display:none"'; ?>>
				<div class="communityally-member-cover-image-title"><?php esc_html_e( 'Change Cover Image', 'buddypress' ); ?></div>
				<div class="bp-cover-image">
					<?php if ( ! _device_can_upload() ) : ?>
						<h3 class="upload-instructions"><?php esc_html_e( 'The web browser on your device cannot be used to upload files.', 'buddypress' ); ?></h3>
					<?php elseif ( is_multisite() && ! is_upload_space_available() ) : ?>
						<h3 class="upload-instructions"><?php esc_html_e( 'Upload Limit Exceeded', 'buddypress' ); ?></h3>
					<?php else : ?>
						<div class="communityally-upload-cover-image">
							<label for="communityally-members-cover-image-browse-button" class="bp-screen-reader-text">
								<?php esc_html_e( 'Select your file', 'buddypress' ); ?>
							</label>
							<input id="communityally-members-cover-image-browse-button" type="button"
								   value="<?php echo esc_attr_x( 'Select your file', 'button', 'buddypress' ); ?>"
								   class="button communityally-upload-image-button communityally-static-upload-trigger" />
						</div>
					<?php endif; ?>
				</div>
				<div class="bp-cover-image-status">
					<p class="warning">
						<?php
						// Get cover image advised dimensions.
						$cover_dimensions = bp_attachments_get_cover_image_dimensions('members');

						echo sprintf(esc_html__('For better results, make sure to upload an image that is larger than %1$spx wide, and %2$spx tall.', 'buddypress'),
								(int) $cover_dimensions['width'],
								(int) $cover_dimensions['height']
							);
						?>
					</p>
				</div>
				<div class="bp-cover-image-manage" id="communityally-members-cover-image-delete"
					 <?php echo $has_cover_image ? '' : 'style="display:none"'; ?> >
					<p><?php esc_html_e("If you'd like to delete your current cover image but not upload a new one, please use the delete Cover Image button.", 'buddypress'); ?></p>
					<button type="button" class="button edit communityally-delete-image-button" id="communityally-members-delete-cover-image">
						<?php
						echo esc_html_x('Delete My Cover Image', 'button', 'buddypress');
						?>
					</button>
				</div>
			</div>
			<div communityally-members-settings="notifications"  <?php echo 'notifications' ===  $selected_tab ? '' : 'style="display:none"'; ?>>
				<form action="#" method="post" class="standard-form" id="communityally-members-update-notification-preference">
					<table class="notification-settings" id="activity-notification-settings">
						<thead>
							<tr>
								<th class="title"></th>
								<th class="communityally-notification-table-element"><?php _e( 'Email', 'communityally' ) ?></th>
								<th class="communityally-notification-table-element"><?php _e( 'Web', 'communityally' )?></th>
							</tr>
						</thead>

						<tbody>
							<tr>
								<td>
									<?php
									/* translators: %s: the displayed user username */
									printf(esc_html__('A member mentions you in an update using "@%s"', 'buddypress'), bp_core_get_user_displayname($display_user_id));
									?>
								</td>
								<td class="communityally-notification-table-element"><input class="communityally-notification-setting-checkbox" type="checkbox" name="notification_activity_new_mention" id="notification-activity-new-mention-email" value="yes" <?php checked( $mention, 'yes', true ) ?>/>
									<label for="notification-activity-new-mention-email" class="communityally-frontend-checkbox"></label></td>
								<td class="communityally-notification-table-element"><input class="communityally-notification-setting-checkbox" type="checkbox" name="notification_activity_new_mention_web" id="notification-activity-new-mention-web" value="yes" <?php checked( $mention_web, 'yes', true ) ?>/>
									<label for="notification-activity-new-mention-web" class="communityally-frontend-checkbox"></label></td>
							</tr>

							<tr>
								<td><?php esc_html_e( "A member replies to an update or comment you've posted", 'buddypress' ) ?></td>
								<td class="communityally-notification-table-element"><input class="communityally-notification-setting-checkbox" type="checkbox" name="notification_activity_new_reply" id="notification-activity-new-reply-email" value="yes" <?php checked( $reply, 'yes', true ) ?>/>
									<label for="notification-activity-new-reply-email" class="communityally-frontend-checkbox"></label></td>
								<td class="communityally-notification-table-element"><input class="communityally-notification-setting-checkbox" type="checkbox" name="notification_activity_new_reply_web" id="notification-activity-new-reply-web" value="yes" <?php checked( $reply_web, 'yes', true ) ?>/>
									<label for="notification-activity-new-reply-web" class="communityally-frontend-checkbox"></label></td>
							</tr>

							<tr <?php echo CommunityAllySettings::is_messaging_enabled() ? '' : 'style="display:none"'; ?>>
								<td><?php esc_html_e('A member sends you a new message', 'buddypress'); ?></td>
								<td class="communityally-notification-table-element">
									<input class="communityally-notification-setting-checkbox" type="checkbox"
										   name="notification_messages_new_message" id="notification-private-message-email"
										   value="yes" <?php checked($private_message_email, 'yes', true) ?>/>
									<label for="notification-private-message-email" class="communityally-frontend-checkbox"></label></td>
								<td class="communityally-notification-table-element">
									<input class="communityally-notification-setting-checkbox" type="checkbox"
										   name="notification_messages_new_message_web" id="notification-private-message-web"
										   value="yes" <?php checked($private_message_web, 'yes', true) ?>/>
									<label for="notification-private-message-web" class="communityally-frontend-checkbox"></label></td>
							</tr>
						</tbody>
					</table>
					<input type="submit" name="submit" value="<?php esc_html_e('Save Changes', 'buddypress'); ?>" class="communityally-member-profile-setting-submit" />
				</form>
			</div>
		</div>
	</div>
</div>