<?php
$selected_item = $nav_items[$subpage];
if (!empty($selected_item['parent'])) {
	$selected_parent_slug = $selected_item['parent'];
	?>
	<nav class="bp-navs bp-subnavs no-ajax user-subnav" id="subnav" role="navigation" aria-label="<?php esc_attr_e( 'Notifications menu', 'buddypress' ); ?>">
		<ul class="subnav">
			<?php
			foreach ($nav_items as $key => $item) {
				// do not show sub items
				if (empty($item['parent']) || $selected_parent_slug !== $item['parent']) {
					continue;
				}
				?>
				<li class="bp-groups-admin-tab <?php echo empty($item['selected']) ? '' : 'current selected'; ?>">
					<a href="<?php echo esc_attr($item['url']); ?>" class="communityally-subnav-<?php echo $key; ?>">
						<?php echo esc_attr($item['name']); ?>
					</a>
				</li>
			<?php } ?>
		</ul>
	</nav>
	<?php
}