<?php
/**
 * BuddyPress - Activity Loop
 *
 * @version 3.1.0
 */

bp_nouveau_before_loop();

$r = bp_parse_args(bp_ajax_querystring( 'activity' ));
$scope = 'groups';
if (!empty($args)) {
	if (!empty($args['r'])) {
		$r = $args['r'];
	}
	if (!empty($args['scope'])) {
		$scope = $args['scope'];
	}
}
$target_activity_found = true;
if (!empty($args['activity_to_show'])) {
	$target_activity_found = false;
}
$current_page = 1;
$has_activity = bp_has_activities($r);
if ($has_activity) :
	while ($has_activity) {
		while ( bp_activities() ) {
			$activity = bp_the_activity();
			$show_all_comments = false;
			if (!empty($args['activity_to_show'])) {
				if (CommunityAlly_Groups_Setup::does_activity_has_id($activity, $args['activity_to_show'])) {
					$target_activity_found = true;
					$show_all_comments = true;
				}
			}
			bp_get_template_part('activity/entry', null, array('show-all-comments' => $show_all_comments));
		}
		if ($target_activity_found) {
			break;
		}
		++$current_page;
		$r['page'] = $current_page;
		$has_activity = bp_has_activities($r);
	}

	if ( bp_activity_has_more_items() ) : ?>

<?php
$load_more_attribute = '';
if (isset($args['group_id'])) {
	$load_more_attribute = 'communityally-load-more="groups|' . $args['group_id'] . '"';
} elseif (bp_is_group()) {
	$load_more_attribute = 'communityally-load-more="groups|' . bp_get_current_group_id() . '"';
}

?>
		<li class="load-more" <?php echo $load_more_attribute; ?>>
			<a href="<?php bp_activity_load_more_link(); ?>"><?php echo esc_html_x( 'Load More', 'button', 'buddypress' ); ?></a>
		</li>

	<?php endif; ?>

<?php elseif (empty($r['pinned']) || 'only-pinned' !== $r['pinned']) :
	if ( isset($r['search_terms']) && !empty($r['search_terms']) ) {
		bp_nouveau_user_feedback( 'activity-filter-none' );
	} elseif ('favorites' === $scope) { // display message specific to the favorites page
		bp_nouveau_user_feedback( 'favorites-none' );
	} else {
		bp_nouveau_user_feedback( 'activity-loop-none' );
	}
endif; ?>

<?php bp_nouveau_after_loop(); ?>
