<?php
/**
 * BP Nouveau Activity Comment form template.
 *
 * @since 3.0.0
 * @version 3.1.0
 */

if ( ! bp_nouveau_current_user_can( 'comment_activity' ) || ! bp_activity_can_comment() ) {
	return;
} ?>

<form action="<?php bp_activity_comment_form_action(); ?>" method="post" id="ac-form-<?php bp_activity_id(); ?>" class="ac-form communityally-activity-comment-form" <?php bp_activity_comment_form_nojs_display(); ?>>
	<div class="communityally-activity-comment-form-meta">
		<div class="communityally-activity-comment-form-avatar">
			<?php bp_loggedin_user_avatar( array( 'type' => 'comment_thumb' ) ); ?>
		</div>
		<div class="ac-reply-content">
			<div class="ac-textarea">
				<textarea id="ac-input-<?php bp_activity_id(); ?>" class="ac-input bp-suggestions communityally-autogrow-textarea" name="ac_input_<?php bp_activity_id(); ?>"
						  data-suggestions-group-id="<?php echo bp_get_current_group_id(); ?>" ></textarea>
			</div
			<input type="hidden" name="comment_form_id" value="<?php bp_activity_id(); ?>" />
			<div id="communityally-activity-add-image-attachment-<?php echo bp_get_activity_id(); ?>-container" class="communityally-activity-attachments"></div>
			<div id="communityally-activity-add-file-attachment-<?php echo bp_get_activity_id(); ?>-container" class="communityally-activity-file-attachments"></div>

			<div class="communityally-activity-form-options">
				<div class="communityally-activity-edit-control">
					<div class="communityally-activity-add-image-button communityally-activity-add-image-attachment-trigger"
						 id="communityally-activity-add-image-attachment-<?php echo bp_get_activity_id(); ?>"></div>
					<div class="communityally-activity-add-file-button communityally-activity-add-file-attachment-trigger"
						 id="communityally-activity-add-file-attachment-<?php echo bp_get_activity_id(); ?>"></div>
				</div>
				<div class="communityally-comment-form-buttons">
					<?php
					printf(
						'<input type="reset" class="text-button communityally-activity-reset-button" value="%s" />',
						esc_html( _x( 'Cancel', 'button', 'buddypress' ) )
					);
					bp_nouveau_submit_button( 'activity-new-comment', bp_get_activity_id() );
					?>
				</div>
			</div>
		</div>
	</div>

</form>
