<?php
/**
 * BuddyPress - Activity Stream Comment
 *
 * This template is used by bp_activity_comments() functions to show
 * each activity.
 *
 * @since 3.0.0
 * @version 7.0.0
 */

bp_nouveau_activity_hook( 'before', 'comment' ); ?>

<?php $show_comments = bp_is_single_activity();
if ($args && !empty($args['to_show'])) {
	$show_comments |= $args['to_show'];
}
$show_comments = $show_comments ? '' : 'display:none';
$comment_user_id = bp_get_activity_comment_user_id();
$member_profile_url = CommunityAlly_Members_Setup::get_members_page_url('profile', $comment_user_id);
$esc_member_profile_url = esc_attr($member_profile_url);
?>
<li style="<?php echo $show_comments ?>" id="acomment-<?php bp_activity_comment_id(); ?>" class="comment-item communityally-comment" data-bp-activity-comment-id="<?php bp_activity_comment_id(); ?>">
	<div class="communityally-comment-main-content communityally-activity-resettable-container">
		<div class="communityally-comment-header">
			<div class="acomment-avatar item-avatar communityally-avatar-comment-thumb-size">
				<a href="<?php echo $esc_member_profile_url; ?>">
					<?php
					bp_activity_avatar(
						array(
							'type'    => 'comment_thumb',
							'user_id' => $comment_user_id,
						)
					);
					?>
				</a>
			</div>

			<div class="communityally-comment-section">
				<div class="acomment-meta">

					<?php bp_nouveau_activity_comment_action(); ?>

				</div>
				<div class="acomment-content communityally-comment-content">
					<div class="comment-content">
						<?php bp_activity_comment_content(); ?>
					</div>
					<?php
					global $activities_template;
					$raw_content = $activities_template->activity->current_comment->content;
					bp_nouveau_activity_edit_form($raw_content);
					?>
				</div>
			</div>

		</div>

		<?php
		$attachments = bp_nouveau_activity_comment_get_attachments();
		$image_attachments = array();
		if (!empty($attachments['image'])) {
			$image_attachments = $attachments['image'];
		}
		?>
		<div class="communityally-activity-attachments <?php echo (1 === count($image_attachments)) ? 'communityally-activity-single-attachment-container': ''; ?>">

			<?php
			$bp_attachments_uploads_dir = bp_attachments_user_file_upload_dir();
			foreach ($image_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/attachment', null, array(
					'attachment_ordinal' => $attachment_ordinal,
					'attachment' => $attachment_settings,
					'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>

		</div>

		<?php
		$file_attachments = array();
		if (!empty($attachments['file'])) {
			$file_attachments = $attachments['file'];
		}
		?>
		<div class="communityally-activity-file-attachments">

			<?php
			foreach ($file_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/file-attachment', null, array(
					'attachment_ordinal' => $attachment_ordinal,
					'attachment' => $attachment_settings,
					'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>

		</div>

		<?php bp_nouveau_activity_comment_buttons( array( 'container' => 'div' ) ); ?>
	</div>

	<?php bp_nouveau_activity_recurse_comments(bp_activity_current_comment(), $args); ?>
</li>

<?php
bp_nouveau_activity_hook( 'after', 'comment' );
