<?php
/**
 * BP Nouveau Activity Comment form template.
 *
 * @since 3.0.0
 * @version 3.1.0
 */

if ( ! communityally_activity_user_can_edit() ) {
	return;
}
$comment_id = bp_get_activity_comment_id();
$unique_identifier = false === $comment_id ? bp_get_activity_id() : $comment_id;
$attachments = false === $comment_id ? bp_nouveau_activity_get_attachments() : bp_nouveau_activity_comment_get_attachments();
$content = $args['content'];
// & is stored as &amp; in the database, so we need to reverse the change.
$content = str_replace('&amp;', '&', $content);
?>

<form action="<?php communityally_activity_edit_form_action(); ?>" method="post" id="edit-form-<?php echo $unique_identifier; ?>" class="edit-form communityally-activity-edit-post-form">
	<div class="ac-edit-content">
		<div class="ac-textarea">
			<textarea id="edit-input-<?php echo $unique_identifier; ?>"
					  class="ac-input bp-suggestions communityally-autogrow-textarea" data-suggestions-group-id="<?php echo bp_get_current_group_id(); ?>"
					  name="ac_input_<?php echo $unique_identifier; ?>"><?php echo communityallly_activity_generate_editable_text($content); ?></textarea>
			<input type="hidden" name="mentions" value="<?php echo esc_attr(json_encode(communityallly_activity_generate_mention_inputs($content))); ?>">
		</div>
		<input type="hidden" name="edit_form_id" value="<?php echo $unique_identifier; ?>" />
		<?php
		$image_attachments = array();
		if (!empty($attachments['image'])) {
			$image_attachments = $attachments['image'];
		}
		?>
		<div id="communityally-activity-add-image-attachment-button-edit-<?php echo $unique_identifier; ?>-container"
			 class="communityally-activity-edit-attachments">
			<?php
			$bp_attachments_uploads_dir = bp_attachments_user_file_upload_dir();
			foreach ($image_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/edit-attachment', null, array(
						'attachment_ordinal' => $attachment_ordinal,
						'attachment' => $attachment_settings,
						'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>

		</div>

		<?php
		$file_attachments = array();
		if (!empty($attachments['file'])) {
			$file_attachments = $attachments['file'];
		}
		?>

		<div id="communityally-activity-add-file-attachment-button-edit-<?php echo $unique_identifier; ?>-container"
			 class="communityally-activity-edit-file-attachments">
			<?php
			foreach ($file_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/edit-file-attachment', null, array(
						'attachment_ordinal' => $attachment_ordinal,
						'attachment' => $attachment_settings,
						'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>
		</div>

		<div class="communityally-activity-form-options">
			<div class="communityally-activity-edit-control">
				<div class="communityally-activity-add-image-button communityally-activity-add-image-attachment-trigger"
					 communityally-activity-add-attachment-existing-count="<?php echo count($image_attachments); ?>"
					 id="communityally-activity-add-image-attachment-button-edit-<?php echo $unique_identifier; ?>">
				</div>
				<div class="communityally-activity-add-file-button communityally-activity-add-file-attachment-trigger"
					 communityally-activity-add-attachment-existing-count="<?php echo count($file_attachments); ?>"
					 id="communityally-activity-add-file-attachment-button-edit-<?php echo $unique_identifier; ?>"></div>
			</div>
			<div class="communityally-comment-form-buttons">
				<?php
					printf(
						'<input type="reset" class="text-button communityally-activity-edit-reset-button" value="%s" />',
						esc_html( _x( 'Cancel', 'button', 'communityally' ) )
					);
					if (false === $comment_id) {
						bp_nouveau_submit_button( 'activity-edit-post', $unique_identifier );
					} else {
						bp_nouveau_submit_button( 'activity-edit-comment', $unique_identifier );
					}
				?>
			</div>
		</div>
	</div>

</form>
