<?php
/**
 * BuddyPress - Activity Stream (Single Item)
 *
 * This template is used by activity-loop.php and AJAX functions to show
 * each activity.
 *
 * @since 3.0.0
 * @version 3.0.0
 */
global $activities_template;
$is_pinned = 'pinned_activity' === bp_get_activity_type();
$just_posted_class = '';
if (!empty($args['just_posted'])) {
	$just_posted_class = ' newest_groups_activity';
}
$user_id = $activities_template->activity->user_id;
$member_profile_url = CommunityAlly_Members_Setup::get_members_page_url('profile', $user_id);
$esc_member_profile_url = esc_attr($member_profile_url);
?>

<li class="<?php bp_activity_css_class(); echo $just_posted_class; ?>" id="activity-<?php bp_activity_id(); ?>" data-bp-activity-id="<?php bp_activity_id(); ?>" data-bp-timestamp="<?php bp_nouveau_activity_timestamp(); ?>">
	<div class="communityally-activity communityally-activity-resettable-container">
		<div class="communityally-activity-header">
			<div class="communityally-activity-header-description">
				<div class="activity-avatar item-avatar communityally-avatar-comment-thumb-size">

					<a href="<?php echo $esc_member_profile_url; ?>">

						<?php bp_activity_avatar( array( 'type' => 'comment_thumb' )); ?>

					</a>

				</div>

				<div class="activity-header communityally-activity-description">

					<?php bp_activity_action(); ?>

				</div>
			</div>

			<?php if ($is_pinned) { ?>
				<div class="communityally-activity-pinned-label">
					<span class="dashicons dashicons-admin-post"></span>
				</div>
			<?php } ?>
		</div>

		<div class="activity-content communityally-activity-content">

			<?php if ( bp_nouveau_activity_has_content() ) : ?>

				<div class="activity-inner">

					<?php bp_nouveau_activity_content(); ?>

				</div>

			<?php endif; ?>
			<?php
			$raw_content = $activities_template->activity->content;
			bp_nouveau_activity_edit_form($raw_content);
			?>

		</div>

		<?php $attachments = bp_nouveau_activity_get_attachments();
		$image_attachments = array();
		if (!empty($attachments['image'])) {
			$image_attachments = $attachments['image'];
		}
		?>
		<div class="communityally-activity-attachments <?php echo (1 === count($image_attachments)) ? 'communityally-activity-single-attachment-container': ''; ?>">

			<?php
			$bp_attachments_uploads_dir = bp_attachments_user_file_upload_dir();
			foreach ($image_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/attachment', null, array(
					'attachment_ordinal' => $attachment_ordinal,
					'attachment' => $attachment_settings,
					'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>

		</div>

		<?php
		$file_attachments = array();
		if (!empty($attachments['file'])) {
			$file_attachments = $attachments['file'];
		}
		?>
		<div class="communityally-activity-file-attachments">

			<?php
			foreach ($file_attachments as $attachment_ordinal => $attachment) {
				$attachment_settings = maybe_unserialize($attachment);
				$local_path = trailingslashit($bp_attachments_uploads_dir['path']) . $attachment_settings['path'];
				bp_get_template_part('activity/file-attachment', null, array(
					'attachment_ordinal' => $attachment_ordinal,
					'attachment' => $attachment_settings,
					'baseurl' => $bp_attachments_uploads_dir['url']
					)
				);
			} ?>

		</div>

		<?php bp_nouveau_activity_hook( 'before', 'entry_comments' ); ?>

		<div class="communityally-activity-footer">
			<?php bp_nouveau_activity_entry_buttons(array('pinned' => $is_pinned)); ?>

			<?php $comment_count = bp_activity_get_comment_count();
			if ( $comment_count || ( is_user_logged_in() && ( bp_activity_can_comment() || bp_is_single_activity() ) ) ) : ?>
				<div class="communityally-activity-comment-toggle-all" communityally-activity-comment-toggle-count="<?php echo $comment_count?>">
					<?php if ($comment_count && $comment_count > 1 && !bp_is_single_activity()) : ?>
						<button class="text-button" type="button" data-bp-show-comments="show-all">
							<span class="communityally-activity-comment-count"><?php echo $comment_count; ?></span> <?php _e( 'Comments', 'buddypress' ) ?>
						</button>
					<?php else : ?>
						<button class="text-button" type="button" data-bp-show-comments="hide-all">
							<span class="communityally-activity-comment-count"><?php echo $comment_count; ?></span> <?php _e( 'Comments', 'buddypress' ) ?>
						</button>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
	</div>

	<div class="activity-comments" >

		<?php if ( $comment_count || ( is_user_logged_in() && ( bp_activity_can_comment() || bp_is_single_activity() ) ) ) : ?>
			<div class="communityally-activity-toggle-previous-comment" communityally-activity-comment-toggle-count="<?php echo $comment_count?>" >
				<?php if ($comment_count > 1) :
					$show_all_comments = false;
					if (!empty($args) && !empty($args['show-all-comments'])) {
						$show_all_comments = true;
					}
					?>
					<button <?php echo $show_all_comments ? 'style="display:none"' : ''; ?> class="text-button communityally-activity-show-previous-comment" type="button">
						<?php echo esc_html(__('View Additional Comments', 'communityally')); ?>
					</button>
					<button <?php echo $show_all_comments ? '' : 'style="display:none"'; ?> class="text-button communityally-activity-hide-previous-comment" type="button">
						<?php echo esc_html(__('Hide All Comments', 'communityally')); ?>
					</button>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php bp_activity_comments($args); ?>

		<?php bp_nouveau_activity_comment_form(); ?>

	</div>

	<?php bp_nouveau_activity_hook( 'after', 'entry_comments' ); ?>

</li>

<?php
bp_nouveau_activity_hook( 'after', 'entry' );
