<?php
/**
 * BuddyPress - Groups Activity
 *
 * @since 3.0.0
 * @version 8.0.0
 */

$group_id = $args['group_id'];
$group = groups_get_group($group_id);
$activity_args = bp_parse_args(bp_ajax_querystring( 'activity' ));
$activity_args['object'] = 'groups';
$activity_args['primary_id'] = $group_id;
$activity_args['excluded_types'] = array('joined_group');	// do not show "a member has joined the group" activities

$whatsnew_placeholder_text = __("What's new, %s?", 'buddypress' );
$default_search_text = __('Search Feed...', 'communityally');
if (communityally_current_group_is_child_group($group)) {
	$whatsnew_placeholder_text = __('Leave a reply!', 'communityally');
	$default_search_text = __('Search Discussions...', 'communityally');
}
$user_displayname = bp_get_loggedin_user_fullname();
$whatsnew_placeholder_text = sprintf($whatsnew_placeholder_text, bp_get_user_firstname($user_displayname));
$whatsnew_aria_text = __( 'Post what\'s new', 'buddypress' );
?>

<div class="communityally-activity-form activity-update-form" communityally-group-id="<?php echo $args['group_id']; ?>">
	<h2 class="bp-screen-reader-text"><?php echo esc_html_x( 'Post Update', 'heading', 'buddypress' ); ?></h2>
	<form name="whats-new-form" method="post" id="whats-new-form" class="activity-form activity-form-expanded communityally-shortcode-new-activity">
		<div id="whats-new-header" class="whats-new-header communityally-activity-form-header">
			<div id="communityally-activity-form-meta" class="communityally-activity-form-meta">
				<div class="communityally-avatar-thumb-size">
					<?php bp_loggedin_user_avatar( array( 'type' => 'comment_thumb' ) ); ?>
				</div>
			</div>
			<div id="whats-new-content" class="whats-new-content">
				<div id="whats-new-textarea" class="whats-new-textarea">
					<textarea name="whats-new" cols="50" rows="4" placeholder="<?php echo esc_attr($whatsnew_placeholder_text); ?>"
							  data-suggestions-group-id="<?php echo $group_id; ?>"
							  aria-label="<?php echo esc_attr($whatsnew_aria_text); ?>" id="whats-new"
							  class="bp-suggestions communityally-autogrow-textarea"></textarea>
				</div>
			</div>
		</div>
		<div id="communityally-activity-add-image-attachment-new-<?php echo $group_id; ?>-container"
			 class="whats-new-attachments communityally-activity-attachments"></div>
		<div id="communityally-activity-add-file-attachment-new-<?php echo $group_id; ?>-container"
			 class="whats-new-file-attachments communityally-activity-file-attachments"></div>
		<div id="whats-new-options" class="communityally-activity-new-form-options">
			<div id="whats-new-edit-control" class="communityally-activity-edit-control">
				<input type="hidden" name="group-id" value="<?php echo $group_id; ?>" />
				<div class="communityally-activity-add-image-button communityally-activity-add-image-attachment-trigger"
					 id="communityally-activity-add-image-attachment-new-<?php echo $group_id; ?>"></div>
				<div class="communityally-activity-add-file-button communityally-activity-add-file-attachment-trigger"
					 id="communityally-activity-add-file-attachment-new-<?php echo $group_id; ?>"></div>
			</div>
			<div id="whats-new-submit" class="whats-new-submit in-profile">
				<input type="reset" id="aw-whats-new-reset" class="text-button small communityally-activity-reset-button"
					   value="<?php echo esc_attr(_x('Cancel', 'button', 'buddypress')); ?>">
				<input type="hidden" class="communityally-activity-submit-nonce" name="nonce" value="<?php echo esc_attr(wp_create_nonce('post_update')); ?>" />
				<input type="submit" id="aw-whats-new-submit" class="button communityally-button communityally-activity-submit-button"
					   name="aw-whats-new-submit" value="<?php echo esc_html__('Post Update', 'communityally'); ?>">
			</div>
		</div>
	</form>
</div>

<div class="subnav-filters filters clearfix communityally-search-row">

	<ul>
		<li class="group-act-search"><?php bp_get_template_part('common/search/search-form', null, array(
			'search-id' => 'group_activity_' . $group_id,
			'object' => array('group', 'activity'),
			'default-search-text' => $default_search_text,
			)); ?></li>
	</ul>

</div><!-- // .subnav-filters -->

<div id="activity-stream" class="activity single-group communityally-shortcode-activity-stream" data-bp-list="activity">

<ul class="activity-list item-list bp-list communityally-group-pinned-activity-list-<?php echo $group_id; ?>">
	<?php
	$activity_args['pinned'] = 'only-pinned';
	$pinned_activity_content = communityally_activity_template_loader('activity', '', '', array('r' => $activity_args, 'group_id' => $group_id));
	if (!empty($pinned_activity_content) && !empty($pinned_activity_content['contents'])) {
		echo $pinned_activity_content['contents'];
	}
	?>
</ul>

<ul class="activity-list item-list bp-list communityally-group-activity-list-<?php echo $group_id; ?>"
	communityally-heartbeat-check="group_activity|<?php echo $group_id; ?>">
	<?php
	$activity_args['pinned'] = 'exclude-pinned';
	$activity_id_to_show = false;
	if (!empty($args['activity_to_show'])) {
		$activity_id_to_show = $args['activity_to_show'];
	}
	$activity_content = communityally_activity_template_loader('activity', '', '', array(
		'r' => $activity_args,
		'group_id' => $group_id,
		'activity_to_show' => $activity_id_to_show,
		));
	if (!empty($activity_content) && !empty($activity_content['contents'])) {
		echo $activity_content['contents'];
	}
	?>
</ul>

</div><!-- .activity -->

<?php
bp_nouveau_group_hook( 'after', 'activity_content' );
