<?php
/**
 * BuddyPress - Groups Admin
 *
 * @since 3.0.0
 * @version 3.0.0
 */

$group_id = $args['group_id'];
$group = groups_get_group($group_id);

$form_action_url = add_query_arg(array(
	'action' => 'communityally_groups_edit_details',
	'group_id' => $group_id,
	'nonce' => wp_create_nonce('communityally-groups-edit-details-' . $group_id),
	), $args['ajax_url']);
?>
<div class="communityally-group-admin-content-container">
	<nav class="bp-navs bp-subnavs no-ajax group-subnav" id="subnav" role="navigation" aria-label="<?php esc_attr_e( 'Group administration menu', 'buddypress' ); ?>">
		<ul class="subnav">
			<li class="bp-groups-admin-tab current selected">
				<a href="<?php echo esc_attr($args['base_url'] . 'admin/'); ?>">
					<?php echo esc_html__('Details', 'buddypress'); ?>
				</a>
			</li>
			<li class="bp-groups-admin-tab">
				<a href="<?php echo esc_attr($args['base_url'] . 'group-cover-image/'); ?>">
					<?php echo esc_html__('Cover Image', 'buddypress'); ?>
				</a>
			</li>
		</ul>
	</nav>
	
	<?php bp_nouveau_template_notices(); ?>
	
	<form action="<?php echo esc_attr($form_action_url); ?>" id="group-settings-form" class="standard-form" method="post">
		<div class="communityally-group-admin-edit-details-screen">
			<div class="communityally-group-admin-edit-details-title">
				<?php esc_html_e( 'Edit Group Name &amp; Description', 'buddypress' ); ?>
			</div>
	
			<div class="communityally-group-admin-edit-container">
				<label class="communityally-group-edit-name" for="group-name"><?php esc_html_e( 'Group Name (required)', 'buddypress' ); ?></label>
				<input type="text" name="group-name" id="group-name" value="<?php echo esc_attr(bp_group_name($group)); ?>" aria-required="true" />
	
				<label class="communityally-group-edit-description" for="group-desc"><?php esc_html_e( 'Group Description', 'communityally' ); ?></label>
				<textarea name="group-desc" id="group-desc"><?php echo bp_group_description_editable($group); ?></textarea>
	
				<?php if ( !bp_is_running_wp( '5.9.0', '>=' ) || !wp_is_block_theme() ) : ?>
				<label class="communityally-group-edit-template" for="group-template"><?php esc_html_e( 'Theme Template', 'communityally' ); ?></label>
				<select name="group-template" id="group-template">
					<option value="">Default template</option>
					<?php
					$selected_template = bp_groups_get_theme_template($group);
					$theme = wp_get_theme();
					$templates = $theme->get_page_templates();
					foreach ($templates as $key => $label) {
						echo '<option value="' . esc_attr($key) . '"' . ($key === $selected_template ? 'selected="selected"' : '') . '>' . esc_html($label) . '</option>';
					}
					?>
				</select>
				<?php endif; ?>
			</div>
		</div>
		<p class="communityally-group-admin-edit-button-container">
			<input type="submit" value="<?php echo esc_attr__('Save Changes', 'buddypress'); ?>" class="communityally-group-admin-edit-save" name="save" />
		</p>
	</form><!-- #group-settings-form -->
</div>