<?php
/**
 * BP Nouveau Group's edit details template.
 *
 * @since 3.0.0
 * @version 3.1.0
 * @version 4.0.0 Removed 'Notify group members' checkbox in favor of hooked callback.
 *
 * CommunityAlly Phase 1 Change, moving everything into else clause
 * to prevent breaking public group creation if the feature is brought back
 */
?>

<?php if ( bp_is_group_create() ) : ?>

	<h3 class="bp-screen-title creation-step-name">
		<?php esc_html_e( 'Enter Group Name &amp; Description', 'buddypress' ); ?>
	</h3>

	<label for="group-name"><?php esc_html_e( 'Group Name (required)', 'buddypress' ); ?></label>
	<input type="text" name="group-name" id="group-name" value="<?php if ( bp_is_group_create() ) : echo esc_attr( bp_get_new_group_name() ); else : echo esc_attr( bp_get_group_name() ); endif; ?>" aria-required="true" />

	<label for="group-desc"><?php esc_html_e( 'Group Description', 'communityally' ); ?></label>
	<textarea name="group-desc" id="group-desc"><?php bp_is_group_create() ? bp_new_group_description() : bp_group_description_editable(); ?></textarea>

<?php else : ?>

	<div class="communityally-group-admin-edit-details-screen">
		<div class="communityally-group-admin-edit-details-title">
			<?php esc_html_e( 'Edit Group Name &amp; Description', 'buddypress' ); ?>
		</div>

		<div class="communityally-group-admin-edit-container">
			<label class="communityally-group-edit-name" for="group-name"><?php esc_html_e( 'Group Name (required)', 'buddypress' ); ?></label>
			<input type="text" name="group-name" id="group-name" value="<?php if ( bp_is_group_create() ) : echo esc_attr( bp_get_new_group_name() ); else : echo esc_attr( bp_get_group_name() ); endif; ?>" aria-required="true" />

			<label class="communityally-group-edit-description" for="group-desc"><?php esc_html_e( 'Group Description', 'communityally' ); ?></label>
			<textarea name="group-desc" id="group-desc"><?php bp_is_group_create() ? bp_new_group_description() : bp_group_description_editable(); ?></textarea>

			<?php if ( !bp_is_running_wp( '5.9.0', '>=' ) || !wp_is_block_theme() ) : ?>
			<label class="communityally-group-edit-template" for="group-template"><?php esc_html_e( 'Theme Template', 'communityally' ); ?></label>
			<select name="group-template" id="group-template">
				<option value="">Default template</option>
				<?php
				$selected_template = bp_groups_get_theme_template();
				$theme = wp_get_theme();
				$templates = $theme->get_page_templates();
				foreach ($templates as $key => $label) {
					echo '<option value="' . esc_attr($key) . '"' . ($key === $selected_template ? 'selected="selected"' : '') . '>' . esc_html($label) . '</option>';
				}
				?>
			</select>
			<?php endif; ?>
		</div>
	</div>
<?php endif; ?>
