<?php
/**
 * CommunityAlly - Child Groups Home
 * 		display a single group as a discussion
 *
 * @since CommunityAlly 1.2
 */
$current_group = groups_get_current_group();
$group_creator_id = $current_group->creator_id;
$date_created = $current_group->date_created;
$parent_group = groups_get_group($current_group->parent_id);
$group_has_cover_image = bp_attachments_get_group_has_cover_image($current_group->id);
if ($group_has_cover_image) {
	$group_cover_image_url = bp_attachments_get_attachment( 'url', array(
		'object_dir' => 'groups',
		'item_id'    => $current_group->id,
	) );
}
?>
<div id="communityally-wait-overlay">
	<div class="communityally-wait-animation">
		<div class="communityally-wait-circle"></div>
	</div>
</div>
<?php
if ( bp_has_groups() ) :
	while ( bp_groups() ) :
		bp_the_group(); // necessary for buddypress to determine correct current action
?>
<a href="<?php echo esc_html( bp_get_group_permalink($parent_group) . 'discussion' ); ?>" class="communityally-discussion-back-button"><i class="bi bi-arrow-left"></i></a>
<div class="bp-wrap">
	<div class="communityally-discussion-topic-container">
		<div class="communityally-discussion-topic"><?php echo esc_html($current_group->name); ?></div>
		<div class="communityally-discussion-topic-info">
			<?php echo sprintf(__('Created by %1$s on %2$s in %3$s', 'communityally'), bp_core_get_user_displayname($group_creator_id), $date_created,
					'<a href="' . esc_html( bp_get_group_permalink($parent_group) . 'discussion' ) . '">' . esc_html($parent_group->name) . '</a>');
			?>
		</div>
		<div class="communityally-discussion-topic-description"><?php echo esc_html($current_group->description); ?></div>
		<img class="communityally-discussion-cover-image" src="<?php echo ($group_has_cover_image && !empty($group_cover_image_url)) ? esc_attr($group_cover_image_url) : ''; ?>" />
	</div>
	<div id="item-body" class="item-body communityally-discussion-item-body">

		<?php bp_nouveau_group_template_part(); ?>

	</div><!-- #item-body -->

</div><!-- // .bp-wrap -->

<?php endwhile;
endif;