<?php
/**
 * BuddyPress - Groups Cover Image Header.
 *
 * @since 3.0.0
 * @version 7.0.0
 *
 * CommunityAlly Phase 1 Change, removed template part, header-item-actions.php as group admin/mods are not shown in phase 1
 */
$group_id = $args['group_id'];
$group = groups_get_group($group_id);
$group_has_cover_image = bp_attachments_get_group_has_cover_image($group_id);
$group_cover_image_url = '';
if ($group_has_cover_image) {
	$group_cover_image_url = bp_attachments_get_attachment( 'url', array(
		'object_dir' => 'groups',
		'item_id'    => $group_id,
	) );
}
?>

<div id="cover-image-container" class="communityally-header-image">
	<div id="header-cover-image" <?php echo $group_has_cover_image ? '' : 'class="communityally-default-header"'; ?> >
		<h1 class="communityally-group-header-image-name">
			<?php bp_group_name($group) ?>
		</h1>
		<img class="communityally-header-cover-image" src="<?php echo empty($group_cover_image_url) ? '' : esc_attr($group_cover_image_url); ?>" />
	</div>
	<div id="item-header-cover-image">

			<div id="item-header-avatar">
				<?php bp_group_avatar(array('group' => $group)); ?>
			</div><!-- #item-header-avatar -->

	</div><!-- #item-header-cover-image -->
</div><!-- #cover-image-container -->

<div class="communityally-group-header-content">
	<h1 class="communityally-group-name"><?php bp_group_name($group) ?></h1>

	<?php
	$group_description = bp_get_group_description($group);
	if (!empty($group_description)) : ?>
		<div class="communityally-group-description">
			<?php echo $group_description; ?>
		</div><!-- //.group_description -->
	<?php endif; ?>
</div>
