<?php
/**
 * CommunityAlly - Groups Discussion
 *
 * @since CommunityAlly 1.2
 */
$group_id = $args['group_id'];
$current_group = groups_get_group($group_id);
?>
<div id="discussion-template">
	<div id="communityally-wait-overlay">
		<div class="communityally-wait-animation">
			<div class="communityally-wait-circle"></div>
		</div>
	</div>
	<!-- Child-group creation modal -->
	<div class="communityally-modal-container" id="communityally-add-child-group-modal-<?php echo $group_id; ?>"
		 communityally-add-child-group-modal="<?php echo $group_id; ?>" style="display:none;">
		<div class="communityally-discussion-add-child-group-modal">
			<div class="communityally-modal-header"><?php echo esc_html__('New Discussion', 'communityally'); ?>
				<div class="communityally-modal-close" communityally-modal-close="communityally-add-child-group-modal-<?php echo $group_id; ?>"></div>
			</div>
			<div class="communityally-modal-content">
				<div class="communityally-modal-subheader"><?php echo esc_html__('Discussion Title', 'communityally'); ?></div>
				<input class="communityally-input" name="title" communityally-param="title" type="text"
					   communityally-data-dependency-source="add-discussion-title-<?php echo $group_id; ?>"
					   placeholder="<?php echo esc_html__('Discussion title here', 'communityally') ?>" />
				<div class="communityally-modal-subheader"><?php echo esc_html__('Description', 'communityally'); ?></div>
				<textarea class="communityally-textarea" name="description" communityally-param="description" cols="30" rows="10"></textarea>
			</div>
			<div class="communityally-modal-submit" style="display:none"
				 hide-toggle communityally-data-dependency="add-discussion-title-<?php echo $group_id; ?>" communityally-data-dependency-value-not="">
				<div class="communityally-modal-submit-button" communityally-add-child-group-submit="<?php echo $group_id; ?>">
					<?php echo esc_html__('Create Discussion', 'communityally'); ?>
				</div>
			</div>
		</div>
	</div>

	<div class="communityally-discussion-content-header-container">
		<div class="communityally-discussion-content-header"><?php echo esc_html(sprintf(__('Discussions in %s', 'communityally'), $current_group->name)); ?></div>
		<?php
		if ( bp_group_is_admin() ) {
			echo '<div class="button communityally-discussion-add-group-button" communityally-discussion-add-group-button="' . $group_id . '">' .
				esc_html__('New Discussion', 'communityally') . '</div>';
		}
		?>
	</div>

	<!-- Display all child groups of this group-->
	<div class="communityally-discussion-content-topics-container" communityally-discussion-content-topics-container="<?php echo $group_id; ?>"><?php echo communityally_get_child_group_list_display($current_group->id); ?></div>
	<div class="communityally-discussion-empty-display" style="display:none"><?php echo esc_html__('There is no discussion here...', 'communityally'); ?></div>
</div>
