<?php
/**
 * BuddyPress - Groups Admin
 *
 * @since 3.0.0
 * @version 3.0.0
 */

$group_id = $args['group_id'];
$group = groups_get_group($group_id);

$has_cover_image = bp_attachments_get_group_has_cover_image($group_id);
?>

<nav class="bp-navs bp-subnavs no-ajax group-subnav" id="subnav" role="navigation" aria-label="<?php esc_attr_e( 'Group administration menu', 'buddypress' ); ?>">
	<ul class="subnav">
		<li class="bp-groups-admin-tab">
			<a href="<?php echo esc_attr($args['base_url'] . 'admin/'); ?>">
				<?php echo esc_html__('Details', 'buddypress'); ?>
			</a>
		</li>
		<li class="bp-groups-admin-tab current selected">
			<a href="<?php echo esc_attr($args['base_url'] . 'group-cover-image/'); ?>">
				<?php echo esc_html__('Cover Image', 'buddypress'); ?>
			</a>
		</li>
	</ul>
</nav>

<div class="communityally-group-admin-cover-image-title">
	<?php esc_html_e( 'Change Cover Image', 'buddypress' ); ?>
</div>

<div class="communityally-cover-image">
	<?php if ( ! _device_can_upload() ) : ?>
		<h3 class="upload-instructions"><?php esc_html_e( 'The web browser on your device cannot be used to upload files.', 'buddypress' ); ?></h3>
	<?php elseif ( is_multisite() && ! is_upload_space_available() ) : ?>
		<h3 class="upload-instructions"><?php esc_html_e( 'Upload Limit Exceeded', 'buddypress' ); ?></h3>
	<?php else : ?>
		<div class="communityally-upload-cover-image">
			<label for="bp-browse-button" class="bp-screen-reader-text">
				<?php esc_html_e( 'Select your file', 'buddypress' ); ?>
			</label>
			<input id="bp-browse-button" communityally-group-id="<?php echo $group_id; ?>" type="button"
				   value="<?php echo esc_attr_x( 'Select your file', 'button', 'buddypress' ); ?>"
				   class="button communityally-upload-image-button communityally-static-upload-trigger" />
		</div>
	<?php endif; ?>
</div>
<div class="bp-cover-image-status">
	<p class="warning">
		<?php
		// Get cover image advised dimensions.
		$cover_dimensions = bp_attachments_get_cover_image_dimensions('groups');

		echo sprintf(esc_html__('For better results, make sure to upload an image that is larger than %1$spx wide, and %2$spx tall.', 'buddypress'),
				(int) $cover_dimensions['width'],
				(int) $cover_dimensions['height']
			);
		?>
	</p>
</div>
<div class="bp-cover-image-manage" id="communityally-group-cover-image-delete"
	 <?php echo $has_cover_image ? '' : 'style="display:none"'; ?> >
	<p><?php esc_html_e( "If you'd like to remove the existing group cover image but not upload a new one, please use the delete group cover image button.", 'buddypress' ); ?></p>
	<?php $delete_param = $group_id . '|' . wp_create_nonce('communityally-delete-cover-image-' . $group_id); ?>
	<button type="button" class="button edit communityally-delete-image-button"
			communityally-delete-cover-image-param="<?php echo esc_attr($delete_param); ?>">
		<?php
		echo esc_html_x( 'Delete Group Cover Image', 'button', 'buddypress' );
		?>
	</button>
</div>
