<?php
/**
 * Group Members Loop template
 *
 * @since 3.0.0
 * @version 3.2.0
 */
global $members_template;

$members_arg = wp_parse_args($args, array(
	'page' => 1,
	));
$current_user = get_current_user_id();
?>
<div id="communityally-group-members-container">
<?php if (bp_group_has_members($members_arg)) : ?>

	<ul id="members-list" class="item-list members-group-list bp-list grid three">

		<?php
		while ( bp_group_members() ) :
			bp_group_the_member();

			$member_user_id = bp_get_group_member_id();
			$member_profile_url = CommunityAlly_Members_Setup::get_members_page_url('profile', $member_user_id);
			$esc_member_profile_url = esc_attr($member_profile_url);

			$user_link_attr = '';
			if ($member_user_id !== $current_user) {
				$encrypted_user_id = apply_filters('accessally_get_encrypted_user_request_arg', $member_user_id, 'communityally');
				$user_link_attr = 'communityally-user-link="' . esc_attr($encrypted_user_id) . '"';
			}
		?>

			<li <?php bp_member_class( array( 'item-entry' ) ); ?> data-bp-item-id="<?php echo esc_attr($member_user_id); ?>" data-bp-item-component="members">

				<div class="list-wrap">

					<div class="item-avatar communityally-avatar-full-size">
						<a <?php echo $user_link_attr; ?> href="<?php echo $esc_member_profile_url; ?>">
							<?php bp_group_member_avatar(); ?>
						</a>
					</div>

					<div class="item">

						<div class="item-block">
							<h3 class="list-title member-name">
								<a <?php echo $user_link_attr; ?> href="<?php echo $esc_member_profile_url; ?>"><?php echo $members_template->member->display_name; ?></a>
							</h3>

							<p class="communityally-group-member-role">
								<?php communityally_group_member_role();?>
							</p>
							<p class="communityally-group-member-joined-timestamp joined item-meta">
								<?php bp_group_member_joined_since(); ?>
							</p>
						</div>

					</div>

				</div><!-- // .list-wrap -->

			</li>

		<?php endwhile; ?>

	</ul>

	<div class="bp-pagination bottom" data-bp-pagination="mlpage">
		<?php
		global $members_template;
		?>
		<div class="pag-count bottom">
			<p class="pag-data">
				<?php
				if ( 1 == $members_template->total_member_count ) {
					esc_html_e('Viewing 1 member', 'buddypress');
				} else {
					$start_num = intval(($members_template->pag_page - 1) * $members_template->pag_num) + 1;
					$from_num = number_format_i18n($start_num);
					$to_num = number_format_i18n(min($start_num + ($members_template->pag_num - 1), $members_template->total_member_count));
					$total = number_format_i18n($members_template->total_member_count);
					/* translators: 1: member from number. 2: member to number. 3: total members. */
					echo sprintf(_n('Viewing %1$s - %2$s of %3$s member', 'Viewing %1$s - %2$s of %3$s members', $members_template->total_member_count, 'buddypress'), $from_num, $to_num, $total);
				}
				?>
			</p>
		</div>

		<?php
		$pagination_links = paginate_links(array(
			'base'      => '#%#%',
			'format'    => '',
			'total'     => !empty($members_template->pag_num) ? ceil($members_template->total_member_count / $members_template->pag_num) : $members_template->total_member_count,
			'current'   => $members_template->pag_page,
			'prev_text' => '&larr;',
			'next_text' => '&rarr;',
			'mid_size'  => 1,
			'add_args'  => array(),
		));
		if (!empty($pagination_links)) :
		?>
			<div class="bp-pagination-links bottom" communityally-group-members-page-update="<?php echo esc_attr($args['group_id']); ?>">
				<p class="pag-data">
					<?php echo wp_kses_post($pagination_links); ?>
				</p>
			</div>
		<?php endif; ?>

	</div>

<?php else : ?>

	<aside class="bp-feedback bp-messages info">
		<span class="bp-icon" aria-hidden="true"></span>
		<p><?php esc_html_e('Sorry, there were no group members found.', 'buddypress')?></p>
	</aside>

<?php endif; ?>
</div>
