<?php
/**
 * BuddyPress - Groups Members
 *
 * @since 3.0.0
 * @version 3.0.0
 */

$group_id = $args['group_id'];
$group = groups_get_group($group_id);
?>

<div class="communityally-group-members-header-container">
	<h2 class="communityally-group-members-title">
		<?php
			$title = esc_html__('Members', 'buddypress') . ' (' . groups_get_groupmeta($group_id, 'total_member_count') . ')';
			echo $title;
		?>
	</h2>

	<div class="subnav-filters filters clearfix no-subnav communityally-search-row">
		<div class="group-search members-search bp-search">
			<form action="" method="get" class="bp-dir-search-form" role="search" communityally-groups-members-search="<?php echo $group_id; ?>">
				<button type="submit" class="nouveau-search-submit communityally-search-submit">
					<span class="dashicons dashicons-search" aria-hidden="true"></span>
					<span id="button-text" class="bp-screen-reader-text"><?php echo esc_html_x('Search', 'button', 'buddypress'); ?></span>
				</button>

				<input type="search" class="communityally-search" communityally-groups-members-search-input="<?php echo $group_id; ?>"
					   placeholder="<?php esc_attr_e('Search Members...', 'buddypress'); ?>" />
			</form>
		</div>

		<div class="component-filters clearfix">
			<div id="groups_members-order-select">
				<label for="groups_members-order-by" class="bp-screen-reader-text">
					<span ><?php echo esc_html__('Order By:', 'buddypress'); ?></span>
				</label>
				<div class="select-wrap">
					<select id="groups_members-order-by" communityally-groups-members-order-update="<?php echo $group_id; ?>">
						<option value="last_joined"><?php echo esc_html__('Newest', 'buddypress'); ?></option>
						<option value="first_joined"><?php echo esc_html__('Oldest', 'buddypress'); ?></option>
						<option value="group_activity"><?php echo esc_html__('Group Activity', 'buddypress'); ?></option>
						<option value="alphabetical"><?php echo esc_html__('Alphabetical', 'buddypress'); ?></option>
					</select>
					<span class="select-arrow" aria-hidden="true"></span>
				</div>
			</div>
		</div>

	</div>
</div>


<div id="members-group-list" class="group_members dir-list" data-bp-list="group_members_<?php echo $group_id; ?>">

	<?php
		$members_content = communityally_activity_template_loader('members', '', 'group_members', array('group_id' => $group_id));
		if (!empty($members_content) && !empty($members_content['contents'])) {
			echo $members_content['contents'];
		}
	?>

</div><!-- .group_members.dir-list -->
