<?php
/**
 * CommunityAlly - Discussion list page individual discussion entry template
 *
 * @param $args = array (
 * 		'group_object' => BP_Group object
 * 		'info_string' => String
 * )
 * @since CommunityAlly 1.2
 */
$individual_group = $args['group_object'];
$group_id = esc_html($individual_group->id);
$esc_parent_group_id = esc_html($args['parent_id']);
$info_string = $args['info_string'];
?>
<div class="communityally-discussion-entry">
	<div class="communityally-discussion-entry-title-container">
		<div class="communityally-discussion-entry-title-text-wrapper">
			<a class="communityally-discussion-entry-title" href="<?php echo esc_html( bp_get_group_permalink( $individual_group ) ); ?>"><?php echo esc_html( $individual_group->name ); ?></a>
			<div class="communityally-discussion-entry-info"><?php echo esc_html($info_string); ?></div>
		</div>
	</div>
	<?php if (bp_group_is_admin() || bp_current_user_can('bp_moderate')) {?>
		<div class="communityally-discussion-edit-button" communityally-edit-discussion-id="<?php echo $group_id; ?>"></div>
		<div class="communityally-discussion-delete-button" communityally-delete-discussion-id="<?php echo $group_id; ?>|<?php echo $esc_parent_group_id; ?>"></div>
		<div class="communityally-discussion-entry-shortcode">
            <div class="communityally-discussion-shortcode-copy-button communityally-general-grey-button" communityally-discussion-shortcode-copy-button="<?php echo $group_id; ?>">Copy Shortcode</div>
			<div class="communityally-discussion-shortcode-copy-success"><?php esc_html_e('Successfully copied!', 'communityally'); ?></div>
			<div class="communityally-discussion-shortcode-copy-fail">
				<?php esc_html_e('Copy failed. Please highlight and copy manually.'); ?>
				<span class="communityally-shortcode-copy-fail-text"></span>
			</div>
		</div>
	<?php } ?>
</div>
<div class="communityally-modal-container" id="communityally-edit-child-group-modal-<?php echo $group_id; ?>" style="display:none;"
	 communityally-edit-child-group-modal="<?php echo $group_id; ?>">
	<div class="communityally-discussion-add-child-group-modal">
		<div class="communityally-modal-header"><?php echo esc_html__('Edit Discussion', 'communityally'); ?>
			<div class="communityally-modal-close" communityally-modal-close="communityally-edit-child-group-modal-<?php echo $group_id; ?>"></div>
		</div>
		<div class="communityally-modal-content">
			<div class="communityally-modal-subheader"><?php echo esc_html__('Discussion Title', 'communityally'); ?></div>
			<input class="communityally-input" name="title" communityally-param="title" type="text"
				   communityally-data-dependency-source="edit-discussion-title-<?php echo $group_id; ?>"
				   placeholder="<?php esc_html_e('Discussion title here', 'communityally'); ?>" value="<?php echo esc_html($individual_group->name); ?>" />
			<div class="communityally-modal-subheader"><?php echo esc_html__('Description', 'communityally'); ?></div>
			<textarea class="communityally-textarea" name="description" communityally-param="description" cols="30" rows="10"><?php echo esc_textarea($individual_group->description); ?></textarea>
		</div>
		<div class="communityally-modal-submit"
			 hide-toggle communityally-data-dependency="edit-discussion-title-<?php echo $group_id; ?>" communityally-data-dependency-value-not="">
			<div class="communityally-modal-submit-button" communityally-discussion-edit-modal-submit="<?php echo $group_id; ?>|<?php echo $esc_parent_group_id; ?>">
				<?php echo esc_html__('Update Discussion', 'communityally'); ?></div>
		</div>
	</div>
</div>