<?php
/**
 * BuddyPress Single Groups item Navigation
 *
 * @since 3.0.0
 * @version 3.0.0
 */
$nav_items = $args['items'];
?>

<nav class="main-navs no-ajax bp-navs single-screen-navs horizontal groups-nav" id="object-nav"
	 role="navigation" aria-label="<?php esc_attr_e( 'Group menu', 'buddypress' ); ?>">
	<ul>
		<?php
		foreach ($nav_items as $item) {
		?>
			<li class="bp-groups-tab <?php echo empty($item['selected']) ? '' : 'current selected'; ?>">
				<a href="<?php echo esc_attr($item['url']); ?>">
					<?php echo esc_attr($item['name']); ?>

					<?php if (!empty($item['count'])) { ?>
						<span class="count"><?php echo esc_html($item['count']); ?></span>
					<?php } ?>
				</a>
			</li>
		<?php } ?>
	</ul>
</nav>
