<?php
/**
 * BuddyPress - Users Cover Image Header
 *
 * @since 3.0.0
 * @version 7.0.0
 */

$display_user_id = bp_displayed_user_id();
$user_has_cover_image = bp_attachments_get_user_has_cover_image($display_user_id);
$user_cover_image_url = '';
if ($user_has_cover_image) {
	$user_cover_image_url = bp_attachments_get_attachment( 'url', array(
		'item_id'   => $display_user_id,
	) );
}
?>

<div id="cover-image-container" class="communityally-header-image">
	<div id="header-cover-image" <?php echo $user_has_cover_image ? '' : 'class="communityally-default-header"'; ?> >
		<h1 class="communityally-member-header-image-name">
			<?php echo esc_html(get_bloginfo( 'name' )); ?>
		</h1>
		<img class="communityally-header-cover-image" src="<?php echo empty($user_cover_image_url) ? '' : esc_attr($user_cover_image_url); ?>" />
	</div>
	<div id="item-header-cover-image">
		<?php
		/*<div id="item-header-avatar">
			<a href="<?php bp_displayed_user_link(); ?>">

				<?php bp_displayed_user_avatar( 'type=full' ); ?>

			</a>
		</div><!-- #item-header-avatar -->

		<div id="item-header-content">

			<?php if ( bp_is_active( 'activity' ) && bp_activity_do_mentions() ) : ?>
				<h2 class="user-nicename">@<?php bp_displayed_user_mentionname(); ?></h2>
			<?php endif; ?>

			<?php
			bp_nouveau_member_header_buttons(
				array(
					'container'         => 'ul',
					'button_element'    => 'button',
					'container_classes' => array( 'member-header-actions' ),
				)
			);
			?>

			<?php bp_nouveau_member_hook( 'before', 'header_meta' ); ?>

			<?php if ( bp_nouveau_member_has_meta() ) : ?>
				<div class="item-meta">

					<?php bp_nouveau_member_meta(); ?>

				</div><!-- #item-meta -->
			<?php endif; ?>

			<?php
			bp_member_type_list(
				bp_displayed_user_id(),
				array(
					'label'        => array(
						'plural'   => __( 'Member Types', 'buddypress' ),
						'singular' => __( 'Member Type', 'buddypress' ),
					),
					'list_element' => 'span',
				)
			);
			?>

		</div><!-- #item-header-content -->*/
		?>
	</div><!-- #item-header-cover-image -->
</div><!-- #cover-image-container -->

<div class="communityally-member-header-content">
	<div class="communityally-avatar-full-size">
		<a href="<?php bp_displayed_user_link(); ?>">

			<?php bp_displayed_user_avatar( 'type=full' ); ?>

		</a>
	</div>

	<h1 class="communityally-member-name">
		<?php bp_displayed_user_fullname(); ?>
	</h1>
	<?php
	if ( bp_is_active( 'messages' ) ) { // check if message component is enabled
		bp_send_message_button();
	}
	?>
</div>