<?php
/**
 * BuddyPress - Users Groups
 *
 * @since 3.0.0
 * @version 3.0.0
 *
 * CommunityAlly Phase 1 Change, removed item subnav as it only contains user group list
 */
?>

<?php if ( bp_is_current_action('my-groups') ) : ?>
	<div class="communityally-member-groups-header-container">
		<h2 class="communityally-member-groups-title">
			<?php communityally_member_groups_title(); ?>
		</h2>
		<?php bp_get_template_part( 'common/search-and-filters-bar' ); ?>
	</div>
<?php elseif ( ! bp_is_current_action( 'invites' ) ) : ?>

<?php endif; ?>

<?php

switch ( bp_current_action() ) :

	// Home/My Groups
	case 'my-groups':
		bp_nouveau_member_hook( 'before', 'groups_content' );
		?>

		<div class="groups mygroups" data-bp-list="groups">
			<?php
				$members_content = communityally_activity_template_loader('groups');
				if (!empty($members_content) && !empty($members_content['contents'])) {
					echo $members_content['contents'];
				}
			?>
		</div>

		<?php
		bp_nouveau_member_hook( 'after', 'groups_content' );
		break;

	// Group Invitations
	case 'invites':
		bp_get_template_part( 'members/single/groups/invites' );
		break;

	// Any other
	default:
		bp_get_template_part( 'members/single/plugins' );
		break;
endswitch;
