<?php
/**
 * BuddyPress - Members Notifications Loop
 *
 * @since 3.0.0
 * @version 3.1.0
 */

if ( bp_has_notifications( bp_ajax_querystring( 'notifications' ) ) ) :

	//bp_nouveau_pagination( 'top' ); ?>

	<form action="" method="post" id="notifications-bulk-management" class="standard-form">
		<div class="communityally-notifications-container">
			<div class="communityally-notifications-type">
				<?php
					$notification_type = bp_is_current_action( 'read' ) ? __('Read', 'buddypress') : __('Unread', 'buddypress') . ' (<span class="communityally-notification-count">' . bp_notifications_get_unread_notification_count( bp_displayed_user_id() ) . '</span>)';
					echo $notification_type;
				?>
			</div>
			<table class="notifications bp-tables-user">
				<thead>
					<tr>
						<th class="icon"></th>
						<th class="bulk-select-all">
							<label class="communityally-checkbox-container">
								<input id="select-all-notifications" type="checkbox" class="communityally-checkbox-input">
								<span class="communityally-checkbox-icon"></span>
							</label>
						</th>
						<th class="title"><?php esc_html_e( 'Notifications', 'buddypress' ); ?></th>
						<th class="date">
							<?php esc_html_e( 'Date Received', 'buddypress' ); ?>
							<?php bp_nouveau_notifications_sort_order_links(); ?>
						</th>
						<th class="actions"><?php esc_html_e( 'Actions', 'buddypress' ); ?></th>
					</tr>
				</thead>

				<tbody>

					<?php
					while ( bp_the_notifications() ) :
						bp_the_notification();
					?>

						<tr>
							<td></td>
							<td class="bulk-select-check">
								<label for="<?php bp_the_notification_id(); ?>" class="communityally-checkbox-container">
									<input id="<?php bp_the_notification_id(); ?>" type="checkbox" name="notifications[]" value="<?php bp_the_notification_id(); ?>" class="notification-check communityally-checkbox-input">
									<span class="communityally-checkbox-icon"></span>
								</label>
							</td>
							<?php if ( bp_is_current_action( 'read' ) ) : ?>
								<td class="notification-description"><?php bp_the_notification_description();  ?></td>
							<?php else : ?>
								<td class="notification-description" communityally-notification-id="<?php bp_the_notification_id(); ?>"><?php bp_the_notification_description();  ?></td>
							<?php endif; ?>
							<td class="notification-since"><?php bp_the_notification_time_since(); ?></td>
							<td class="notification-actions"><?php bp_the_notification_action_links(); ?></td>
						</tr>

					<?php endwhile; ?>

				</tbody>
			</table>
		</div>
		<div class="communityally-notifications-bulk-manage-container notifications-options-nav">
			<?php bp_nouveau_notifications_bulk_management_dropdown(); ?>
		</div><!-- .notifications-options-nav -->

		<?php wp_nonce_field( 'notifications_bulk_nonce', 'notifications_bulk_nonce' ); ?>
	</form>

	<?php bp_nouveau_pagination( 'bottom' ); ?>

<?php else : ?>

	<?php bp_nouveau_user_feedback( 'member-notifications-none' ); ?>

<?php endif;
