<?php
/**
 * BuddyPress - Members Single Profile WP
 *
 * @since 3.0.0
 * @version 3.1.0
 */

bp_nouveau_wp_profile_hooks( 'before' ); ?>

<div class="bp-widget wp-profile">

	<h2 class="screen-heading wp-profile-screen communityally-profile-title">
		<?php
		if ( bp_is_my_profile() ) {
			esc_html_e( 'My Profile', 'buddypress' );
		} else {
			printf(
				/* Translators: a member's profile, e.g. "Paul's profile". */
				__( "%s's Profile", 'buddypress' ),
				bp_get_displayed_user_fullname()
			);
		}
		?>
	</h2>

	<div class="accessally-user-profile communityally-accessally-profile">
		<?php
		$communityally_general_settings = CommunityAllySettings::get_general_settings();
		echo do_shortcode('[accessally_user_profile profile_id="' . $communityally_general_settings['select-user-profile'] . '" user_id="' . bp_displayed_user_id() .'"]');
		?>
	</div>

</div>

<?php
bp_nouveau_wp_profile_hooks( 'after' );

