/* jshint browser: true */
/* global BP_Nouveau, plupload, CommunityAllyLoader, tinymce */
/* @since 3.0.0 */
/* @version 8.0.0 */
window.bp = window.bp || {};

( function( bp, $ ) {

	// Bail if not set
	if ( typeof BP_Nouveau === 'undefined' ) {
		return;
	}

	bp.Nouveau = bp.Nouveau || {};

	/** Nouveau activity attachment uploader ****************************************************************/
	function generateCommunityAllyAttachmentItemDisplay($parent, attachmentType, status, name, percent, ordinal, url, path) {
		$parent.empty();
		if ('complete' === status) {
			$parent.removeClass('communityally-attachment-upload-pending');
			let variableName = 'attachment';
			if ('image' === attachmentType) {
				let $imageEl = $('<img class="communityally-attachment-image" />');
				$imageEl.attr('src', url);
				$parent.append($imageEl);
			} else {
				variableName = 'file-attachment';
				let $fileEl = $('<a target="_blank" class="communityally-attachment-file"></a>');
				$fileEl.text(name);
				$fileEl.attr('href', url);
				$parent.append($fileEl);
			}

			let $inputEl = $('<input class="communityally-attachment-input" type="hidden" name="' + variableName + '[' + ordinal + '][name]" />');
			$inputEl.attr('value', name);
			$parent.append($inputEl);

			$inputEl = $('<input class="communityally-attachment-input" type="hidden" name="' + variableName + '[' + ordinal + '][path]" />');
			$inputEl.attr('value', path);
			$parent.append($inputEl);
		} else {
			$parent.addClass('communityally-attachment-upload-pending');
			let displayText = name;
			let $displayEl = $('<span class="communityally-attachment-desc"></span>');
			$displayEl.text(displayText);
			$parent.append($displayEl);

			let $waitEl = $('<div class="communityally-attachment-upload-wait"></div>');
			$parent.append($waitEl);
		}
	}
	function createCommunityallyActivityUploader(uniqueIdentifier, attachmentType, ordinal, after_init_func) {
		ordinal = ordinal || 0;
		let isIE = navigator.userAgent.indexOf('Trident/') !== -1 || navigator.userAgent.indexOf('MSIE ') !== -1,
			itemOrdinal = ordinal,
			params  = BP_Nouveau.upload_settings,
			supports = {
				upload: params.browser.supported
			},
			supported = supports.upload;

		if ( ! supported ) {
			return;
		}

		// Make sure flash sends cookies (seems in IE it does without switching to urlstream mode).
		if ( ! isIE && 'flash' === plupload.predictRuntime( params.defaults ) &&
			( ! params.defaults.required_features || ! params.defaults.required_features.hasOwnProperty( 'send_binary_string' ) ) ) {

			params.defaults.required_features = params.defaults.required_features || {};
			params.defaults.required_features.send_binary_string = true;
		}

		params.defaults.browse_button = uniqueIdentifier;
		if ('image' === attachmentType) {
			params.defaults.filters.mime_types = [{title: 'Images', extensions: 'jpg,gif,png,jpeg'}];
		} else {
			params.defaults.filters.mime_types = [];
		}
		params.defaults.multipart_params.action = 'communityally_activity_upload_file';
		uploader = new plupload.Uploader( params.defaults );

		/**
		 * After the Uploader has been initialized, initialize some behaviors for the dropzone.
		 *
		 * @event Init
		 * @param {plupload.Uploader} uploader Uploader instance.
		 */
		uploader.bind( 'Init', function( uploader ) {
			if ( 'html4' === uploader.runtime ) {
				uploader.settings.multipart_params.html4 = true;
			}
			if (after_init_func) {
				after_init_func();
			}
		} );

		// See https://core.trac.wordpress.org/ticket/37039.
		uploader.bind( 'postinit', function( up ) {
			up.refresh();
		});

		// Init CommunityAlly Uploader.
		uploader.init();

		/**
		 * After files were filtered and added to the queue, create a model for each.
		 *
		 * @event FilesAdded
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {Array}             files    Array of file objects that were added to queue by the user.
		 */
		uploader.bind( 'FilesAdded', function( uploader, files ) {
			let $container = $('#' + uniqueIdentifier + '-container'),
				displayTemplate = '<div class="communityally-attachment-entry" id="' + uniqueIdentifier + '-item-{{ordinal}}" ' +
					'communityally-attachment="{{file-id}}">' +
					'<div class="communityally-attachment-delete-button" communityally-attachment-remove="{{file-id}}"></div>' +
					'</div>';
			for (let i in files) {
				++itemOrdinal;
				let f = files[i],
					displayCode = displayTemplate;
				displayCode = displayCode.replace(/{{ordinal}}/g, itemOrdinal);
				displayCode = displayCode.replace(/{{file-id}}/g, f.id);

				let $entry = $(displayCode),
					$descEl = $('<div class="communityally-attachment-display" communityally-attachment-display="' + f.id + '"></div>');

				generateCommunityAllyAttachmentItemDisplay($descEl, attachmentType, 'upload', f.name, 0, 0, '', '');
				$entry.prepend($descEl);
				$container.append($entry);
			}
			uploader.refresh();
			uploader.start();
		} );

		/**
		 * Update each file item on progress.
		 *
		 * @event UploadProgress
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {Object}            file
		 */
		uploader.bind( 'UploadProgress', function( uploader, file ) {
			let $display = $('[communityally-attachment-display="' + file.id + '"]');
			if ($display.length <= 0) {
				return;
			}
			generateCommunityAllyAttachmentItemDisplay($display, attachmentType, 'upload', file.name, file.percent, 0, '', '');
		} );

		/**
		 * After a file is successfully uploaded, update its model.
		 *
		 * @event FileUploaded
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {plupload.File}     file     File that was uploaded.
		 * @param {Object}            response Object with response properties.
		 * @return {mixed}
		 */
		uploader.bind( 'FileUploaded', function( uploader, file, response ) {
			let $display = $('[communityally-attachment-display="' + file.id + '"]');
			if ($display.length <= 0) {
				return;
			}
			try {
				response = JSON.parse(response.response);

				let ordinal = ++itemOrdinal;
				generateCommunityAllyAttachmentItemDisplay($display, attachmentType, 'complete', response.data.name, 100, ordinal, response.data.url, response.data.path);
			} catch (e) {
				alert(e);
			}
		} );
		uploader.bind('Error', function(up, err) {
			$('#communityally-wait-overlay').hide();
			alert(err.message);
		} );
		return uploader;
	};

	bp.Nouveau.createStaticImageUploader = function(uniqueIdentifier, action, additional_param, after_init_func, upload_success_function) {
		let isIE = navigator.userAgent.indexOf('Trident/') !== -1 || navigator.userAgent.indexOf('MSIE ') !== -1,
			params = BP_Nouveau.upload_settings,
			supports = {
				upload: params.browser.supported
			},
			supported = supports.upload;

		if ( ! supported ) {
			return;
		}

		// Make sure flash sends cookies (seems in IE it does without switching to urlstream mode).
		if ( ! isIE && 'flash' === plupload.predictRuntime( params.defaults ) &&
			( ! params.defaults.required_features || ! params.defaults.required_features.hasOwnProperty( 'send_binary_string' ) ) ) {

			params.defaults.required_features = params.defaults.required_features || {};
			params.defaults.required_features.send_binary_string = true;
		}

		params.defaults.browse_button = uniqueIdentifier;
		params.defaults.filters.mime_types = [{title: 'Images', extensions: 'jpg,gif,png,jpeg'}];
		params.defaults.multipart_params.action = action;
		for (let key in additional_param) {
			params.defaults.multipart_params[key] = additional_param[key];
		}
		uploader = new plupload.Uploader( params.defaults );

		/**
		 * After the Uploader has been initialized, initialize some behaviors for the dropzone.
		 *
		 * @event Init
		 * @param {plupload.Uploader} uploader Uploader instance.
		 */
		uploader.bind( 'Init', function( uploader ) {
			if ( 'html4' === uploader.runtime ) {
				uploader.settings.multipart_params.html4 = true;
			}
			if (after_init_func) {
				after_init_func();
			}
		} );

		// See https://core.trac.wordpress.org/ticket/37039.
		uploader.bind( 'postinit', function( up ) {
			up.refresh();
		});

		// Init CommunityAlly Uploader.
		uploader.init();

		/**
		 * After files were filtered and added to the queue, create a model for each.
		 *
		 * @event FilesAdded
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {Array}             files    Array of file objects that were added to queue by the user.
		 */
		uploader.bind( 'FilesAdded', function( uploader, files ) {
			$('#communityally-wait-overlay').show();
			uploader.refresh();
			uploader.start();
		} );

		/**
		 * After a file is successfully uploaded, update its model.
		 *
		 * @event FileUploaded
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {plupload.File}     file     File that was uploaded.
		 * @param {Object}            response Object with response properties.
		 * @return {mixed}
		 */
		uploader.bind( 'FileUploaded', function(uploader, file, response) {
			try {
				let result = JSON.parse(response.response);

				upload_success_function(result);
			} catch (e) {
				alert(e);
			}
			$('#communityally-wait-overlay').hide();
		} );
		uploader.bind('Error', function(up, err) {
			$('#communityally-wait-overlay').hide();
			alert(err.message);
		} );
		return uploader;
	};

	function get_group_id_of_element(target_element) {
		let $activity_container = $(target_element).parents('[communityally-group-id]');
		if ($activity_container.length <= 0 ) {
			return 0;
		}
		return $activity_container.first().attr('communityally-group-id');
	}
	/**
	 * [Activity description]
	 * @type {Object}
	 */
	bp.Nouveau.Activity = {

		/**
		 * [start description]
		 * @return {[type]} [description]
		 */
		start: function() {
			this.setupGlobals();

			// Listen to events ("Add hooks!")
			this.addListeners();
		},

		/**
		 * [setupGlobals description]
		 * @return {[type]} [description]
		 */
		setupGlobals: function() {
			// Init just posted activities
			this.just_posted    = [];

			// Init current page
			this.current_page   = 1;

			// Init mentions count
			this.mentions_count = Number( $( bp.Nouveau.objectNavParent + ' [data-bp-scope="mentions"]' ).find( 'a span' ).html() ) || 0;

			// HeartBeat Globals
			this.heartbeat_data = {
				newest         : {},
				highlights     : {},
				last_recorded  : 0,
				first_recorded : 0
			};
		},

		/**
		 * [addListeners description]
		 */
		addListeners: function() {
			// HeartBeat listeners
			$( '#buddypress' ).on( 'bp_heartbeat_send', this.heartbeatSend.bind( this ) );
			$( '#buddypress' ).on( 'bp_heartbeat_tick', this.heartbeatTick.bind( this ) );

			// Load newest Activities
			$(document).on('click touchend', '[communityally-load-newest]',
				this.loadNewestActivities.bind( this ));

			// Load more Activities
			$(document).on('click touchend', '[data-bp-list="activity"] li.load-more',
				this.injectActivities.bind(this));

			// Hightlight new activities & clean up the stream
			$( '#buddypress' ).on( 'bp_ajax_request', '[data-bp-list="activity"]', this.scopeLoaded.bind( this ) );

			// Activity comments effect
			$(document).on( 'click touchend', '[data-bp-show-comments]', this.toggleComments );

			// Activity show / hide previous comments effect
			$(document).on( 'click touchend', '.communityally-activity-show-previous-comment', this.showPreviousComments );
			$(document).on( 'click touchend', '.communityally-activity-hide-previous-comment', this.hidePreviousComments );

			// Activity actions
			$(document).on( 'click touchend', '[data-bp-list="activity"] .activity-item', bp.Nouveau, this.activityActions );
			$(document).on( 'keydown', this.commentFormAction );

			// new activity input for shortcodes
			$(document).on( 'submit', 'form.communityally-shortcode-new-activity', bp.Nouveau, this.submitNewActivity );

			// initialize file uploader on click
			$(document).on('click touchend', '.communityally-activity-add-image-attachment-trigger', this.initializeImageUploaderButton);
			$(document).on('click touchend', '.communityally-activity-add-file-attachment-trigger', this.initializeFileUploaderButton);

			$(document).on('click touchend', '[communityally-attachment-remove]', this.removeAttachment );
			$(document).on('click touchend', '[communityally-attachment-remove-temp]', this.removeAttachmentTemporary );
			$(document).on('click touchend', '.communityally-attachment-image-click-open', this.openImageModal );
			$(document).on('click touchend', '.communityally-attachment-image-click-open-window', this.closeImageModal );

			$(document).on('submit', '#group-settings-form', this.showWaitOverlay);
			$(document).on('click touchend', '#bp-browse-button', this.initializeCoverImageUploadButton);
			$(document).on('click touchend', '[communityally-delete-cover-image-param]', this.deleteGroupCoverImage);

			$(document).on('change propertychange keyup input paste', 'textarea.communityally-autogrow-textarea', function() {
				let $this = $(this);
				$this.innerHeight(Math.max(50, this.scrollHeight));
			});

			$(document).on('submit', '[communityally-send-private-message-form]', this.sendPrivateMessage);
			$(document).on('submit', '[communityally-private-message-reply-form]', this.replyPrivateMessage);
			$(document).on('click touchend', '[communityally-messages-add-star]', this.privateMessageAddStar);
			$(document).on('click touchend', '[communityally-messages-remove-star]', this.privateMessageRemoveStar);
		},

		/**
		 * [heartbeatSend description]
		 * @param  {[type]} event [description]
		 * @param  {[type]} data  [description]
		 * @return {[type]}       [description]
		 */
		heartbeatSend: function( event, data ) {
			// because pin posts will be at the top, we need to check the timestamp for all activities
			let $heartbeat_containers = $('[communityally-heartbeat-check]'),
				heartbeat_update_data = {},
				self = this;
			$heartbeat_containers.each(function(index, elem) {
				let $elem = $(elem),
					key = $elem.attr('communityally-heartbeat-check');
				if (!key) {
					return;
				}
				if (key in heartbeat_update_data) {
					return;
				}
				let parts = key.split('|');
				if (parts.length < 2) {
					return;
				}
				let group_id = parts[1],
					$search_box = $('[data-bp-search="' + parts[0] + '_' + group_id + '"] input[type="search"]');
				// do not get heartbeat if search is not empty
				if ($search_box.val().length > 0) {
					return;
				}
				heartbeat_update_data[key] = 0;
				if (key in self.heartbeat_data.newest) {
					heartbeat_update_data[key] = self.heartbeat_data.newest[key]['latest_time'];
				}
				// because the entries are shown in reverse chronological order, we just need to get the first element
				let $first_entry = $elem.find('[data-bp-timestamp]').first();
				if ($first_entry.length > 0) {
					heartbeat_update_data[key] = Math.max(heartbeat_update_data[key], $first_entry.attr('data-bp-timestamp'));
				}
			});

			$.extend(data, { bp_heartbeat: heartbeat_update_data });
		},

		updateNewestActivity: function(key, activity_data) {
			if (key in this.heartbeat_data.newest) {
				this.heartbeat_data.newest[key]['content'] = activity_data['content'] + this.heartbeat_data.newest[key]['content'];
				this.heartbeat_data.newest[key]['latest_time'] = activity_data['latest_time'];
			} else {
				this.heartbeat_data.newest[key] = activity_data;
			}
			let newest_activities_count = Number($(this.heartbeat_data.newest[key]['content']).filter('.activity-item').length);

			// Update the Load Newest li if it already exists.
			let $parent_container = $('[communityally-heartbeat-check="' + key + '"]');
			if ($parent_container.length < 1) {
				return;
			}
			let $existing_load_newest_button = $parent_container.find('li.load-newest'),
				link_text = BP_Nouveau.newest + ' (' + newest_activities_count + ')';
			if ($existing_load_newest_button.length > 0) {
				$existing_load_newest_button.find('a').html(link_text);
			} else {
				$parent_container.prepend('<li class="load-newest" communityally-load-newest="' + key + '"><a href="#newest">' + link_text + '</a></li>');
			}
		},

		/**
		 * [heartbeatTick description]
		 * @param  {[type]} event          [description]
		 * @param  {[type]} data           [description]
		 * @return {[type]}                [description]
		 */
		heartbeatTick: function( event, data ) {
			// Only proceed if we have newest activities
			if (!data || !data.bp_activity_newest_activities) {
				return;
			}
			for (let key in data.bp_activity_newest_activities) {
				this.updateNewestActivity(key, data.bp_activity_newest_activities[key]);
			}
		},

		loadStoredNewestActivities: function(key) {
			if (!(key in this.heartbeat_data.newest)) {
				return;
			}

			let $activities = $(this.heartbeat_data.newest[key]['content']);

			$activities.each(function(index, activity) {
				let activity_id = $(activity).attr('id');
				// remove existing entry with matching ID to avoid duplicates
				$('#' + activity_id).remove();
			} );

			let $all_add_new_buttons = $('[communityally-load-newest="' + key + '"]');

			// Now the stream is cleaned, add the newest activities
			$all_add_new_buttons.after(this.heartbeat_data.newest[key]['content']);

			$all_add_new_buttons.remove();

			// Reset the newest activities now they're displayed
			delete this.heartbeat_data.newest[key];

			// Remove highlight from newly posted message
			setTimeout( function () {
				$('.newest_groups_activity').removeClass('newest_groups_activity');
			}, 3000 );
		},

		loadNewestActivities: function( event ) {
			var $current_target = $(event.currentTarget),
				key = $current_target.attr('communityally-load-newest');

			// Stop event propagation
			event.preventDefault();

			this.loadStoredNewestActivities(key);
		},

		/**
		 * [injectQuery description]
		 * @param  {[type]} event [description]
		 * @return {[type]}       [description]
		 */
		injectActivities: function( event ) {
			var $current_target = $( event.currentTarget ),
				next_page = (Number(this.current_page) * 1) + 1,
				self = this,
				search_terms = '';

			// Stop event propagation
			event.preventDefault();

			$current_target.find( 'a' ).first().addClass( 'loading' );

			// reset the just posted
			this.just_posted = [];

			// Now set it
			$( event.delegateTarget ).children( '.just-posted' ).each( function() {
				self.just_posted.push( $( this ).data( 'bp-activity-id' ) );
			} );

			if ( $( '#buddypress .dir-search input[type=search]' ).length ) {
				search_terms = $( '#buddypress .dir-search input[type=search]' ).val();
			}
			let load_more_attr = $current_target.attr('communityally-load-more'),
				data = {
					object              : 'activity',
					search_terms        : search_terms,
					method              : 'append',
					last_id				: 0,
					target              : '#buddypress [data-bp-list] ul.bp-list'
				};
			if (load_more_attr) {
				let parts = load_more_attr.split('|');
				if ('groups' === parts[0]) {
					data['object'] = 'group_activity_' + parts[1];
					data['target'] = '.communityally-group-activity-list-' + parts[1];

					// because the entries are shown in reverse chronological order, we just need to get the first element
					let $last_entry = $('.communityally-group-activity-list-' + parts[1]).find('[data-bp-activity-id]').last();
					if ($last_entry.length > 0) {
						data['last_id'] = $last_entry.attr('data-bp-activity-id');
					}
				}
			}

			bp.Nouveau.objectRequest(data).done( function( response ) {
				if ( true === response.success ) {
					// remove the "load more" button
					$current_target.remove();

					// Update the current page
					self.current_page = next_page;
				}
			} );
		},

		toggleComments: function( event ) {
			// Stop event propagation
			event.preventDefault();

			var event_button = $( event.target ),
				action = event_button.attr("data-bp-show-comments"),
				$activity_item = event_button.closest('.activity-item');

			// hide the show / hide previous comment section
			$activity_item.find('.communityally-activity-toggle-previous-comment').hide();

			if ('show-all' === action) {
				$activity_item.find( 'ul' ).find( 'li' ).fadeIn(200);
				event_button.attr('data-bp-show-comments', 'hide-all');
			} else {
				event_button.closest('.activity-item').find( 'ul' ).find( 'li' ).fadeOut(200);
				event_button.attr('data-bp-show-comments', 'show-all');
			}
		},

		showPreviousComments: function( event ) {
			// Stop event propagation
			event.preventDefault();

			let $event_button = $( event.target ),
				$activity_item = $event_button.closest('.activity-item');

			$activity_item.find( 'ul' ).find( 'li' ).fadeIn(200);
			$activity_item.find('.communityally-activity-hide-previous-comment').show();
			$activity_item.find('[data-bp-show-comments]').attr('data-bp-show-comments', 'hide-all');
			$event_button.hide();
		},

		hidePreviousComments: function( event ) {
			// Stop event propagation
			event.preventDefault();

			let $event_button = $( event.target ),
				$activity_item = $event_button.closest('.activity-item');

			$activity_item.find( 'ul' ).find( 'li' ).fadeOut(200);
			$activity_item.find('[data-bp-show-comments]').attr('data-bp-show-comments', 'show-all');

			// hide the show / hide previous comment section
			$activity_item.find('.communityally-activity-toggle-previous-comment').hide();
		},

		initializeImageUploaderButton: function() {
			let $this = $(this),
				existing_ordinal = $this.attr('communityally-activity-add-attachment-existing-count');
			if (!existing_ordinal) {
				existing_ordinal = 0;
			}
			createCommunityallyActivityUploader($this.attr('id'), 'image', existing_ordinal, function() {
				$this.removeClass('communityally-activity-add-image-attachment-trigger');
				$this.click();
			} );
		},

		initializeFileUploaderButton: function() {
			let $this = $(this),
				existing_ordinal = $this.attr('communityally-activity-add-attachment-existing-count');
			if (!existing_ordinal) {
				existing_ordinal = 0;
			}
			createCommunityallyActivityUploader($this.attr('id'), 'file', existing_ordinal, function() {
				$this.removeClass('communityally-activity-add-file-attachment-trigger');
				$this.click();
			} );
		},

		showWaitOverlay: function() {
			$('#communityally-wait-overlay').show();
		},

		initializeCoverImageUploadButton: function() {
			let $this = $(this);
			if ($this.hasClass('communityally-static-upload-trigger')) {
				bp.Nouveau.createStaticImageUploader('bp-browse-button', 'communityally_group_upload_cover_image',
					{ group_id : $this.attr('communityally-group-id') },
					function() {
						$this.removeClass('communityally-static-upload-trigger');
						$this.click();
					},
					function(result) {
						let $header = $('#header-cover-image');
						$header.removeClass('communityally-default-header')
								.find('.communityally-header-cover-image').attr('src', result.data.url);

						$('#communityally-group-cover-image-delete').show();
					}
					);
			}
		},

		deleteGroupCoverImage: function() {
			let $this = $(this),
				param = $this.attr('communityally-delete-cover-image-param'),
				parts = param.split('|');
			if (parts.length < 2) {
				return;
			}
			$('#communityally-wait-overlay').show();
			bp.Nouveau.ajax({
				action: 'communityally_group_delete_cover_image',
				group_id: parts[0],
				delete_nonce: parts[1]
			}, 'groups').done(function(response) {
				$('#communityally-wait-overlay').hide();
				if ( false === response.success ) {
					return;
				}
				$('#header-cover-image').addClass('communityally-default-header')
						.find('.communityally-header-cover-image').attr('src', '');
				$('#communityally-group-cover-image-delete').hide();
			});
		},

		removeAttachment: function() {
			let fileId = $(this).attr('communityally-attachment-remove');
			$('[communityally-attachment="' + fileId + '"]').remove();
		},

		removeAttachmentTemporary: function() {
			let $attachment_entry = $(this).closest('.communityally-attachment-entry');
			$attachment_entry.find('input.communityally-attachment-input').removeClass('communityally-attachment-input')
					.addClass('communityally-attachment-removed-temporary');
			$attachment_entry.hide();
		},

		openImageModal: function(e) {
			e.preventDefault();
			let $container = $(this),
				$modal = $container.find('.communityally-attachment-image-click-open-window');
			$modal.show();
			e.stopPropagation(); // prevent ghost clicks on mobile
			return false;
		},

		closeImageModal: function(e) {
			e.preventDefault();
			$(this).hide();
			return false;
		},

		/**
		 * [scopeLoaded description]
		 * @param  {[type]} event [description]
		 * @param  {[type]} data  [description]
		 * @return {[type]}       [description]
		 */
		scopeLoaded: function ( event, data ) {
			// Reset the pagination for the scope.
			this.current_page = 1;

			// Mentions are specific
			if ( 'mentions' === data.scope && undefined !== data.response.new_mentions ) {
				$.each( data.response.new_mentions, function( i, id ) {
					$( '#buddypress #activity-stream' ).find( '[data-bp-activity-id="' + id + '"]' ).addClass( 'newest_mentions_activity' );
				} );

				// Reset mentions count
				this.mentions_count = 0;
			} else if ( undefined !== this.heartbeat_data.highlights[data.scope] && this.heartbeat_data.highlights[data.scope].length ) {
				$.each( this.heartbeat_data.highlights[data.scope], function( i, id ) {
					if ( $( '#buddypress #activity-stream' ).find( '[data-bp-activity-id="' + id + '"]' ).length ) {
						$( '#buddypress #activity-stream' ).find( '[data-bp-activity-id="' + id + '"]' ).addClass( 'newest_' + data.scope + '_activity' );
					}
				} );
			}

			// Reset the newest activities now they're displayed
			this.heartbeat_data.newest = {};
			$.each( $( bp.Nouveau.objectNavParent + ' [data-bp-scope]' ).find( 'a span' ), function( s, count ) {
				if ( 0 === parseInt( $( count ).html(), 10 ) ) {
					$( count ).html( '' );
				}
			} );

			// Activities are now loaded, clear the highlighted activities for the scope
			if ( undefined !== this.heartbeat_data.highlights[ data.scope ] ) {
				this.heartbeat_data.highlights[ data.scope ] = [];
			}

			setTimeout( function () {
				$( '#buddypress #activity-stream .activity-item' ).removeClass( 'newest_' + data.scope +'_activity' );
			}, 3000 );
		},

		/**
		 * [activityActions description]
		 * @param  {[type]} event [description]
		 * @return {[type]}       [description]
		 */
		activityActions: function( event ) {
			var parent = event.data, target = $( event.target ), activity_item = $( event.currentTarget ),
				activity_id = activity_item.data( 'bp-activity-id' ), stream = $( event.delegateTarget ),
				item_id, form;

			// In case the target is set to a span inside the link.
			if ( $( target ).is( 'span' ) ) {
				target = $( target ).closest( 'a' );
			}

			// Pinning
			if ( target.hasClass( 'communityally-activity-pin') || target.hasClass('communityally-activity-unpin') ) {
				let type = target.hasClass( 'communityally-activity-pin' ) ? 'pin' : 'unpin';

				// Stop event propagation
				event.preventDefault();

				target.addClass( 'loading' );

				parent.ajax( { action: 'activity_mark_' + type, 'id': activity_id }, 'activity' ).done( function( response ) {
					target.removeClass( 'loading' );

					if ( false === response.success ) {
						return;
					}

					if ( 'pin' === type ) {
						target.removeClass( 'communityally-activity-pin' );
						target.addClass( 'communityally-activity-unpin' );
					} else if ( 'unpin' === type ) {
						target.removeClass( 'communityally-activity-unpin' );
						target.addClass( 'communityally-activity-pin' );
					}
					target.find('.communityally-activity-pin-label').text(response.data.label);
				} );
			}

			// Favoriting
			if ( target.hasClass( 'fav') || target.hasClass('unfav') ) {
				var type = target.hasClass( 'fav' ) ? 'fav' : 'unfav';

				// Stop event propagation
				event.preventDefault();

				target.addClass( 'loading' );

				parent.ajax( { action: 'activity_mark_' + type, 'id': activity_id }, 'activity' ).done( function( response ) {
					target.removeClass( 'loading' );

					if ( false === response.success ) {
						return;
					} else {
						target.fadeOut( 200, function() {
							if ( $( this ).find( 'span' ).first().length ) {
								$( this ).find( 'span' ).first().html( response.data.content );
							} else {
								$( this ).html( response.data.content );
							}

							if ('false' === $(this).attr('aria-pressed') ) {
								$( this ).attr('aria-pressed', 'true');
							} else {
								$( this ).attr('aria-pressed', 'false');
							}

							$( this ).fadeIn( 200 );
						} );
					}

					if ( 'fav' === type ) {
						if ( undefined !== response.data.directory_tab ) {
							if ( ! $( parent.objectNavParent + ' [data-bp-scope="favorites"]' ).length ) {
								$( parent.objectNavParent + ' [data-bp-scope="all"]' ).after( response.data.directory_tab );
							}
						}

						target.removeClass( 'fav' );
						target.addClass( 'unfav' );

					} else if ( 'unfav' === type ) {
						var favoriteScope = $( '[data-bp-user-scope="favorites"]' ).hasClass( 'selected' ) || $( parent.objectNavParent + ' [data-bp-scope="favorites"]' ).hasClass( 'selected' );

						// If on user's profile or on the favorites directory tab, remove the entry
						if ( favoriteScope ) {
							activity_item.remove();
						}

						if ( undefined !== response.data.no_favorite ) {
							// Remove the tab when on activity directory but not on the favorites tabs
							if ( $( parent.objectNavParent + ' [data-bp-scope="all"]' ).length && $( parent.objectNavParent + ' [data-bp-scope="all"]' ).hasClass( 'selected' ) ) {
								$( parent.objectNavParent + ' [data-bp-scope="favorites"]' ).remove();

							// In all the other cases, append a message to the empty stream
							} else if ( favoriteScope ) {
								stream.append( response.data.no_favorite );
							}
						}

						target.removeClass( 'unfav' );
						target.addClass( 'fav' );
					}
				} );
			}

			// Deleting or spamming
			if ( target.hasClass( 'delete-activity' ) || target.hasClass( 'acomment-delete' ) || target.hasClass( 'spam-activity' ) || target.hasClass( 'spam-activity-comment' ) ) {
				var activity_comment_li = target.closest( '[data-bp-activity-comment-id]' ),
					activity_comment_id = activity_comment_li.data( 'bp-activity-comment-id' ),
					li_parent, comment_count, communityally_toggle_all, deleted_comments_count = 0;

				// Stop event propagation
				event.preventDefault();

				if ( undefined !== BP_Nouveau.confirm && false === window.confirm( BP_Nouveau.confirm ) ) {
					return false;
				}

				target.addClass( 'loading' );

				var ajaxData = {
					action      : 'delete_activity',
					'id'        : activity_id,
					'_wpnonce'  : parent.getLinkParams( target.prop( 'href' ), '_wpnonce' ),
					'is_single' : target.closest( '[data-bp-single]' ).length
				};

				// Only the action changes when spamming an activity or a comment.
				if ( target.hasClass( 'spam-activity' ) || target.hasClass( 'spam-activity-comment' ) ) {
					ajaxData.action = 'bp_spam_activity';
				}

				// Set defaults parent li to activity container
				li_parent = activity_item;

				// If it's a comment edit ajaxData.
				if ( activity_comment_id ) {
					delete ajaxData.is_single;

					// Set comment data.
					ajaxData.id         = activity_comment_id;
					ajaxData.is_comment = true;

					// Set parent li to activity comment container
					li_parent = activity_comment_li;
				}

				parent.ajax( ajaxData, 'activity' ).done( function( response ) {
					target.removeClass( 'loading' );

					if ( false === response.success ) {
						li_parent.prepend( response.data.feedback );
						li_parent.find( '.bp-feedback' ).hide().fadeIn( 300 );
					} else {
						// Specific case of the single activity screen.
						if ( response.data.redirect ) {
							return window.location.href = response.data.redirect;
						}

						if ( activity_comment_id ) {
							deleted_comments_count = 1;

							// Move the form if needed
							activity_item.append( activity_comment_li.find( 'form' ) );

							// Count child comments if there are some
							$.each( activity_comment_li.find( 'li' ), function() {
								deleted_comments_count += 1;
							} );

							// Update the comment count
							communityally_toggle_all = activity_item.find( 'div.communityally-activity-comment-toggle-all' );
							comment_count      = Number( communityally_toggle_all.attr('communityally-activity-comment-toggle-count' ) - deleted_comments_count );
							communityally_toggle_all.attr('communityally-activity-comment-toggle-count', comment_count);
							communityally_toggle_all.find('button .communityally-activity-comment-count').text(comment_count);

							// Clean up the parent activity classes.
							if ( 0 === comment_count ) {
								activity_item.removeClass( 'has-comments' );
							}
						}

						// Remove the entry
						li_parent.slideUp( 300, function() {
							li_parent.remove();
						} );
					}
				} );
			}

			// Reading more
			if ( target.closest( 'span' ).hasClass( 'activity-read-more' ) ) {
				var content = target.closest( 'div' ), readMore = target.closest( 'span' );

				item_id = null;

				if ( $( content ).hasClass( 'activity-inner' ) ) {
					item_id = activity_id;
				} else if ( $( content ).hasClass( 'acomment-content' ) ) {
					item_id = target.closest( 'li' ).data( 'bp-activity-comment-id' );
				}

				if ( ! item_id ) {
					return event;
				}

				// Stop event propagation
				event.preventDefault();

				$( readMore ).addClass( 'loading' );

				parent.ajax( {
					action : 'get_single_activity_content',
					id     : item_id
				}, 'activity' ).done( function( response ) {
					$( readMore ).removeClass( 'loading' );

					if ( content.parent().find( '.bp-feedback' ).length ) {
						content.parent().find( '.bp-feedback' ).remove();
					}

					if ( false === response.success ) {
						content.after( response.data.feedback );
						content.parent().find( '.bp-feedback' ).hide().fadeIn( 300 );
					} else {
						$( content ).slideUp( 300 ).html( response.data.contents ).slideDown( 300 );
					}
				} );
			}

			// Displaying the edit form
			if ( target.hasClass( 'edit' ) || target.parent().hasClass( 'edit' ) ) {
				// Stop event propagation
				event.preventDefault();

				parent.Activity.openCommentEditForm(activity_id);
			}

			// Reset the comment / activity edit form
			if ( target.hasClass( 'communityally-activity-edit-reset-button' ) ) {
				let $parent_container = target.closest('.communityally-activity-resettable-container');
				$parent_container.find('.communityally-attachment-entry').show();
				$parent_container.find('.edit-form').hide();
				$parent_container.find('.activity-inner, .comment-content').show();

				$parent_container.find('.communityally-activity-attachments').show();
				$parent_container.find('.communityally-activity-file-attachments').show();
				$parent_container.find('.communityally-attachment-removed-temporary').addClass('communityally-attachment-input')
						.removeClass('communityally-attachment-removed-temporary');
				// Stop event propagation
				event.preventDefault();
			}

			// Submitting edited posts
			if ( 'edit_form_submit' === target.prop( 'name' ) ) {
				// Stop event propagation
				event.preventDefault();
				parent.Activity.submitPost(parent, target, activity_item, activity_id);
			}

			// Displaying the comment edit form
			if ( target.hasClass( 'edit-comment' ) || target.parent().hasClass( 'edit-comment' ) ) {
				if ( target.closest( 'li' ).data( 'bp-activity-comment-id' ) ) {
					let comment_id = target.closest( 'li' ).data( 'bp-activity-comment-id' );
					parent.Activity.openCommentEditForm(comment_id);
				}
				// Stop event propagation
				event.preventDefault();
			}

			// Submitting edited comments
			if ( 'edit_comment_form_submit' === target.prop( 'name' ) ) {
				// Stop event propagation
				event.preventDefault();
				parent.Activity.submitComment(parent, target, activity_item, activity_id, true);
			}

			// Displaying the comment form
			if ( target.hasClass( 'acomment-reply' ) || target.parent().hasClass( 'acomment-reply' ) ) {
				form = $( '#ac-form-' + activity_id );
				item_id = activity_id;

				// Stop event propagation
				event.preventDefault();

				if ( target.closest( 'li' ).data( 'bp-activity-comment-id' ) ) {
					item_id = target.closest( 'li' ).data( 'bp-activity-comment-id' );
				}

				// ?? hide and display none..
				//form.css( 'display', 'none' );
				form.removeClass( 'root' );
				$('.ac-form').hide();

				/* Remove any error messages */
				$.each( form.children( 'div' ), function( e, err ) {
					if ( $( err ).hasClass( 'error' ) ) {
						$( err ).remove();
					}
				} );

				// It's an activity we're commenting
				if ( item_id === activity_id ) {
					$( '[data-bp-activity-id="' + item_id + '"] .activity-comments' ).append( form );
					form.addClass( 'root' );

				// It's a comment we're replying to
				} else {
					$( '[data-bp-activity-comment-id="' + item_id + '"]' ).append( form );
				}

				form.slideDown( 200 );

				// change the aria state from false to true
				target.attr( 'aria-expanded', 'true' );

				$.scrollTo( form, 500, {
					offset:-100,
					easing:'swing'
				} );

				$( '#ac-form-' + activity_id + ' textarea' ).trigger( 'focus' );
			}

			// Removing the form
			if ( target.hasClass( 'communityally-activity-reset-button' ) ) {

				$( target ).closest( '.ac-form' ).slideUp( 200 );

				// Change the aria state back to false on comment cancel
				$( '.acomment-reply').attr( 'aria-expanded', 'false' );

				// Stop event propagation
				event.preventDefault();
			}

			// Submitting comments and replies
			if ( 'ac_form_submit' === target.prop( 'name' ) ) {
				// Stop event propagation
				event.preventDefault();

				parent.Activity.submitComment(parent, target, activity_item, activity_id, false);
			}
		},

		submitNewActivity: function( event ) {
			// Stop event propagation
			event.preventDefault();

			let parent = event.data,
				target = $( event.target ),
				comment_data,
				group_id = get_group_id_of_element(target),
				communityally_wait_overlay = $('#communityally-wait-overlay'),
				// wait overlay on group pages can be found by id selector, wait overlay in group shortcode can be found by group id
				$form = target.closest( 'form' ),
				$comment_content = $form.find( 'textarea' ).first();

			if (communityally_wait_overlay.length <= 0) {
				communityally_wait_overlay = $('[communityally-wait-overlay="' + group_id + '"]');
			}
			communityally_wait_overlay.show();

			parent.Activity.loadStoredNewestActivities('group_activity|' + group_id);

			// remove any error message
			$form.find('.bp-feedback').remove();

			target.addClass( 'loading' ).prop( 'disabled', true );
			$comment_content.addClass( 'loading' ).prop( 'disabled', true );

			comment_data = {
				action: 'post_update',
				_wpnonce_post_update: $form.find('.communityally-activity-submit-nonce').val(),
				user_id: 0,
				item_id: group_id,
				object: 'group',
				content: $comment_content.val()
			};

			let $mention = $form.find( 'input[name="mentions"]' );
			if ($mention.length > 0) {
				comment_data['mentions'] = $mention.val();
			}

			// wait for upload to finish
			let $pending_uploads = $form.find('.communityally-attachment-upload-pending');
			if ($pending_uploads.length > 0) {
				setTimeout( function() { parent.Activity.submitNewActivity(event); }, 1000);
				return;
			}

			// add attachment inputs
			let $attachment_inputs = $form.find('input.communityally-attachment-input');
			$attachment_inputs.each(function(index, elem) {
				let $elem = $(elem),
					input_name = $elem.attr('name'),
					input_val = $elem.val();
				comment_data[input_name] = input_val;
			});

			parent.ajax( comment_data, 'activity' ).done( function( response ) {
				target.removeClass( 'loading' ).prop( 'disabled', false );
				$comment_content.removeClass( 'loading' ).prop( 'disabled', false );

				if ( false === response.success ) {
					if (response.data && response.data.message) {
						let $error_message = $('<p>').text(response.data.message),
							$message_elem = $('<div class="bp-messages bp-feedback error"><span class="bp-icon" aria-hidden="true"></span></div>');
						$message_elem.append($error_message);

						$form.append($message_elem);
					}
				} else {
					let $the_comment = $($.trim( response.data.activity )),
						$parent_container = $('.communityally-group-activity-list-' + group_id);

					$the_comment.hide();
					$parent_container.prepend($the_comment);
					$parent_container.find('[data-bp-activity-id="' + response.data.id + '"]').fadeIn(200);

					// remove any "no activity" message
					$parent_container.find('.bp-feedback').remove();

					// Remove highlight from newly posted message
					setTimeout( function () {
						$('.newest_groups_activity').removeClass('newest_groups_activity');
					}, 3000 );

					// clear existing content
					$comment_content.val('');

					// remove all attachments
					let $image_container = $form.find('.communityally-activity-attachments');
					$image_container.empty();
					let $file_container = $form.find('.communityally-activity-file-attachments');
					$file_container.empty();
				}

				communityally_wait_overlay.hide();
			} );
		},

		submitPost: function(parent, target, activity_item, activity_id) {
			let post_content, post_data,
				group_id = get_group_id_of_element(target),
				communityally_wait_overlay = (0 === group_id) ? $('#communityally-wait-overlay') : $('[communityally-wait-overlay="' + group_id + '"]'),
				form = target.closest( 'form' );

			communityally_wait_overlay.show();

			post_content = $( form ).find( 'textarea' ).first();

			target.addClass( 'loading' ).prop( 'disabled', true );
			post_content.addClass( 'loading' ).prop( 'disabled', true );

			post_data = {
				action                        : 'edit_activity_post',
				_wpnonce_post_update 		  : $( '#_wpnonce_edit_post' + '_' + activity_id ).val(),
				activity_id                   : activity_id,
				content                       : post_content.val(),
				is_update                     : 'yes'
			};
			let $mention = $( form ).find( 'input[name="mentions"]' );
			if ($mention.length > 0) {
				post_data['mentions'] = $mention.val();
			}

			// [communityally_group] shortcode needed group_id and object in order to successfully post
			let $shortcode_container = $('.communityally-shortcode-activity-stream');
			if ($shortcode_container.length > 0) {
				post_data['object'] = 'group';
				post_data['item_id'] = $shortcode_container.attr('communityally-group-id');
			}

			// wait for upload to finish
			let $pending_uploads = $(form).find('.communityally-attachment-upload-pending');
			if ($pending_uploads.length > 0) {
				setTimeout( function() { parent.Activity.submitPost(parent, target, activity_item, activity_id); }, 1000);
				return;
			}

			// add attachment inputs
			let $attachment_inputs = $(form).find('input.communityally-attachment-input');
			$attachment_inputs.each(function(index, elem) {
				let $elem = $(elem),
					input_name = $elem.attr('name'),
					input_val = $elem.val();
				post_data[input_name] = input_val;
			});

			// Add the Akismet nonce if it exists
			if ( $( '#_bp_as_nonce_' + activity_id ).val() ) {
				post_data['_bp_as_nonce_' + activity_id] = $( '#_bp_as_nonce_' + activity_id ).val();
			}

			parent.ajax( post_data, 'activity' ).done( function( response ) {
				target.removeClass( 'loading' ).prop( 'disabled', false );
				post_content.removeClass( 'loading' ).prop( 'disabled', false );
				if ( false === response.success ) {
					if (response.data.message) {
						form.append(
								$('<div class="bp-feedback bp-messages error"></div>')
								.text(response.data.message)
								.hide().fadeIn(200)
								);
					}
				} else {
					let activity_code = $.trim( response.data.activity );

					form.fadeOut( 200, function() {
						let $activity_element = $('#activity-' + activity_id);
						$activity_element.after($( activity_code ).hide().fadeIn( 200 ));
						$activity_element.remove();
					} );

					// Remove highlight from newly posted messagege
					setTimeout( function () {
						$('.newest_groups_activity').removeClass('newest_groups_activity');
					}, 3000 );

					// remove all attachments
					let $container = $('#communityally-activity-attachment-container-' + activity_id);
					$container.empty();
				}

				communityally_wait_overlay.hide();
			} );
		},

		submitComment: function(parent, target, activity_item, activity_id, is_update) {
			let comment_content, comment_data,
				group_id = get_group_id_of_element(target),
				communityally_wait_overlay = (0 === group_id) ? $('#communityally-wait-overlay') : $('[communityally-wait-overlay="' + group_id + '"]'),
				// wait overlay on group pages can be found by id selector, wait overlay in group shortcode can be found by group id
				$form = target.closest( 'form' ),
				item_id = activity_id;

			communityally_wait_overlay.show();

			let $comment_container = target.closest( 'li' );
			if ( $comment_container.data( 'bp-activity-comment-id' ) ) {
				item_id = $comment_container.data( 'bp-activity-comment-id' );
			}

			comment_content = $form.find( 'textarea' ).first();

			target.addClass( 'loading' ).prop( 'disabled', true );
			comment_content.addClass( 'loading' ).prop( 'disabled', true );

			comment_data = {
				action                        : 'new_activity_comment',
				_wpnonce_new_activity_comment : '',
				comment_id                    : item_id,
				form_id                       : activity_id,
				content                       : comment_content.val(),
				is_update					  : is_update ? 'yes' : 'no'
			};
			if (is_update) {
				comment_data['_wpnonce_new_activity_comment'] = $( '#_wpnonce_new_edit_comment' + '_' + item_id ).val();
			} else {
				comment_data['_wpnonce_new_activity_comment'] = $( '#_wpnonce_new_activity_comment' + '_' + activity_id ).val();
			}

			let $mention = $form.find( 'input[name="mentions"]' );
			if ($mention.length > 0) {
				comment_data['mentions'] = $mention.val();
			}

			// wait for upload to finish
			let $pending_uploads = $form.find('.communityally-attachment-upload-pending');
			if ($pending_uploads.length > 0) {
				setTimeout( function() { parent.Activity.submitComment(parent, target, activity_item, activity_id, is_update); }, 1000);
				return;
			}

			// add attachment inputs
			let $attachment_inputs = $form.find('input.communityally-attachment-input');
			$attachment_inputs.each(function(index, elem) {
				let $elem = $(elem),
					input_name = $elem.attr('name'),
					input_val = $elem.val();
				comment_data[input_name] = input_val;
			});

			// Add the Akismet nonce if it exists
			if ( $( '#_bp_as_nonce_' + activity_id ).val() ) {
				comment_data['_bp_as_nonce_' + activity_id] = $( '#_bp_as_nonce_' + activity_id ).val();
			}

			parent.ajax( comment_data, 'activity' ).done( function( response ) {
				target.removeClass( 'loading' ).prop( 'disabled', false );
				comment_content.removeClass( 'loading' ).prop( 'disabled', false );
				$( '.acomment-reply' ).attr( 'aria-expanded', 'false' );

				if ( false === response.success ) {
					$form.append( $( response.data.feedback ).hide().fadeIn( 200 ) );
				} else {
					var the_comment = $.trim( response.data.contents );

					$form.fadeOut( 200, function() {
						if (is_update) {	// replace the existing element
							let new_comment_id = parseInt(item_id),
								comment_selector;
							if (parseInt(activity_id) === new_comment_id) {
								comment_selector = '#activity-' + new_comment_id;
							} else {
								comment_selector = '#acomment-' + new_comment_id;
							}
							let $comment_element = $(comment_selector);
							$comment_element.after($( the_comment ).hide().fadeIn( 200 ));
							$comment_element.remove();

							// show all child comments because they were generated as hidden. Must re-query using the selector because $comment_element has been removed
							$(comment_selector + ' li').show();
						} else {	// append to parent element
							var activity_comments = $form.parent();
							if ( 0 === activity_comments.children( 'ul' ).length ) {
								if ( activity_comments.hasClass( 'activity-comments' ) ) {	// this is the root activity
									activity_comments.prepend( '<ul></ul>' );
								} else {	// this is a child comment
									activity_comments.append( '<ul></ul>' );
								}
							}

							activity_comments.children( 'ul' ).append( $( the_comment ).hide().fadeIn( 200 ) );
							comment_content.val( '' );

							if ( activity_comments.hasClass( 'activity-comments' ) ) {	// this is the root activity
								activity_comments.parent().addClass( 'has-comments' );
							} else {	// this is a child comment
								activity_comments.addClass( 'has-comments' );
							}
						}
					} );

					if (!is_update) {
						// Set the new count
						let communityally_toggle_all = activity_item.find( 'div.communityally-activity-comment-toggle-all' ),
							comment_count = Number( communityally_toggle_all.attr('communityally-activity-comment-toggle-count') ) + 1;

						// Increment CommunityAlly toggle comment count
						communityally_toggle_all = activity_item.find( 'div.communityally-activity-comment-toggle-all' );
						communityally_toggle_all.attr('communityally-activity-comment-toggle-count', comment_count);
						communityally_toggle_all.find('button .communityally-activity-comment-count').text(comment_count);
					}

					// remove all attachments
					let $image_container = $form.find('.communityally-activity-attachments');
					$image_container.empty();
					let $file_container = $form.find('.communityally-activity-file-attachments');
					$file_container.empty();
				}

				communityally_wait_overlay.hide();
			} );
		},

		/**
		 * [closeCommentForm description]
		 * @param  {[type]} event [description]
		 * @return {[type]}       [description]
		 */
		commentFormAction: function( event ) {
			var element, keyCode;

			event = event || window.event;

			if ( event.target ) {
				element = event.target;
			} else if ( event.srcElement) {
				element = event.srcElement;
			}

			if ( element.nodeType === 3 ) {
				element = element.parentNode;
			}

			if ( event.altKey === true || event.metaKey === true ) {
				return event;
			}

			// Not in a comment textarea, return
			if ( element.tagName !== 'TEXTAREA' || ! $( element ).hasClass( 'ac-input' ) ) {
				return event;
			}

			keyCode = ( event.keyCode ) ? event.keyCode : event.which;

			if ( 27 === keyCode && false === event.ctrlKey  ) {
				if ( element.tagName === 'TEXTAREA' ) {
					$( element ).closest( 'form' ).slideUp( 200 );
				}
			} else if ( event.ctrlKey && 13 === keyCode && $( element ).val() ) {
				$( element ).closest( 'form' ).find( '[type=submit]' ).first().trigger( 'click' );
			}
		},

		openCommentEditForm: function(unique_identifier) {
			let $edit_form = $('#edit-form-' + unique_identifier),
				$entry_container = $edit_form.closest('.communityally-activity-resettable-container'),
				$textarea = $entry_container.find('textarea'),
				chr0 = String.fromCharCode(0),
				imageOrdinal = $edit_form.find('.communityally-activity-edit-attachments .communityally-attachment-entry').length,
				fileOrdinal = $edit_form.find('.communityally-activity-edit-file-attachments .communityally-attachment-entry').length;

			$entry_container.find('.activity-inner, .comment-content').hide();
			$entry_container.find('.communityally-activity-attachments').hide();
			$entry_container.find('.communityally-activity-file-attachments').hide();

			// replace chr0 placeholder with the actual character 0
			$textarea.val($textarea.val().replace(/\*chr0\*/g, chr0));

			$edit_form.show();
			$.scrollTo( $edit_form, 500, {
				offset: -100,
				easing: 'swing'
			} );
		},

		sendPrivateMessage: function(event) {
			event.preventDefault();
			let $form = $(this),
				values = communityally_serialize_value_in_container($form),
				data = {
					action: 'communityally_messages_send_message',
					input: JSON.stringify(values),
					nonce: $form.attr('communityally-send-private-message-form')
				};

			$('#communityally-wait-overlay').show();
			$.ajax({
				type: 'POST',
				url: CommunityAllyLoader.ajax_url,
				data: data,
				success: function(response) {
					try {
						var result = JSON.parse(response);
						if ('status' in result) {
							if ('success' === result['status']) {
								window.location.href = result['redirect'];
							} else {
								throw result['message'];
							}
						}
					} catch (e) {
						let $error_elem = $('#communityally-members-messages-error-message');
						$error_elem.find('p').text(e);
						$error_elem.show();
						$('#communityally-wait-overlay').hide();
					}
				}
			});

			return false;
		},

		replyPrivateMessage: function(event) {
			event.preventDefault();
			let $form = $(this),
				param = $form.attr('communityally-private-message-reply-form'),
				parts = param.split('|');
			if (parts.length < 2) {
				return false;
			}
			let values = communityally_serialize_value_in_container($form),
				data = {
					action: 'communityally_messages_reply_message',
					input: JSON.stringify(values),
					thread_id: parts[0],
					nonce: parts[1]
				};

			$('#communityally-wait-overlay').show();
			$.ajax({
				type: 'POST',
				url: CommunityAllyLoader.ajax_url,
				data: data,
				success: function(response) {
					try {
						var result = JSON.parse(response);
						if ('status' in result) {
							if ('success' === result['status']) {
								if ('undefined' !== typeof tinymce) {
									tinymce.EditorManager.execCommand('mceRemoveEditor', false, 'message_content');
								}
								$('#communityally-members-messages-container').after(result['code']).remove();
								if ('undefined' !== typeof tinymce) {
									tinymce.EditorManager.execCommand('mceAddEditor', true, 'message_content');
								}
							} else {
								throw result['message'];
							}
						}
					} catch (e) {
						let $error_elem = $('#communityally-members-messages-error-message');
						$error_elem.find('p').text(e);
						$error_elem.show();
					}
					$('#communityally-wait-overlay').hide();
				}
			});

			return false;
		},

		privateMessageAddStar: function(event) {
			let thread_id = $(this).attr('communityally-messages-add-star'),
				data = {
					action: 'communityally_messages_bulk_action',
					bulk_action: 'add-star',
					ids: thread_id,
					silent: 'yes',
					nonce: CommunityAllyLoader.nonce
				};
			$.ajax({
				type: 'POST',
				url: CommunityAllyLoader.ajax_url,
				data: data
			});

			$('.communityally-messages-is-starred-' + thread_id).val('yes').change();
			return false;
		},

		privateMessageRemoveStar: function(event) {
			let thread_id = $(this).attr('communityally-messages-remove-star'),
				data = {
					action: 'communityally_messages_bulk_action',
					bulk_action: 'remove-star',
					ids: thread_id,
					silent: 'yes',
					nonce: CommunityAllyLoader.nonce
				};
			$.ajax({
				type: 'POST',
				url: CommunityAllyLoader.ajax_url,
				data: data
			});

			$('.communityally-messages-is-starred-' + thread_id).val('no').change();
			return false;
		}
	};

	// Launch BP Nouveau Activity
	bp.Nouveau.Activity.start();

	// <editor-fold defaultstate="collapsed" desc="bulk select / operation">
	function bulkSelectAll() {
		let $this = $(this),
			identifier = $this.attr('communityally-bulk-select-all'),
			is_checked = $this.prop('checked');
		$('[communityally-individual-checkbox="' + identifier + '"]').prop('checked', is_checked);
		updateBulkOperationContainer(identifier);
	}
	function bulkSelectOperationChange() {
		let identifier = $(this).attr('communityally-bulk-select');
		updateBulkOperationSubmitButton(identifier);
	}
	function bulkSelectIndividualCheckboxChange() {
		let $this = $(this),
			identifier = $this.attr('communityally-individual-checkbox');

		// uncheck the select all box
		if (!$this.is(':checked')) {
			$('[communityally-bulk-select-all="' + identifier + '"]').prop('checked', false);
		}
		updateBulkOperationContainer(identifier);
	}
	function updateBulkOperationContainer(identifier) {
		let $bulk_operation_container = $('[communityally-bulk-operation="' + identifier + '"]'),
			$checkboxes = $('[communityally-individual-checkbox="' + identifier + '"]:checked');
		if ($checkboxes.length > 0) {
			$bulk_operation_container.show();
			return;
		}
		$bulk_operation_container.hide();
	}
	function updateBulkOperationSubmitButton(identifier) {
		let $button = $('[communityally-bulk-submit="' + identifier + '"]'),
			$operation_select = $('[communityally-bulk-select="' + identifier + '"]');
		if ($operation_select.val()) {
			$button.show();
			return;
		}
		$button.hide();
	}
	$(document).on('change', '[communityally-bulk-select-all]', bulkSelectAll);
	$(document).on('change', '[communityally-individual-checkbox]', bulkSelectIndividualCheckboxChange);
	$(document).on('change', '[communityally-bulk-select]', bulkSelectOperationChange);
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="private message bulk operation">
	function privateMessageSubmitBulkOperation() {
		let identifier = $(this).attr('communityall-messages-bulk-submit'),
			$checkboxes = $('[communityally-individual-checkbox="' + identifier + '"]:checked'),
			$operation_select = $('[communityally-bulk-select="' + identifier + '"]'),
			operation = $operation_select.val(),
			selected_threads = [],
			i, thread_id;
		if ('delete' === operation) {
			let conf = confirm(CommunityAllyLoader.messages.DELETE_MESSAGE_WARNING);
			if (!conf) {
				return false;
			}
		}
		if ($checkboxes.length <= 0 || !operation) {
			return;
		}
		for (i = 0; i < $checkboxes.length; ++i) {
			selected_threads.push($checkboxes[i].value);
		}
		let data = {
				action: 'communityally_messages_bulk_action',
				bulk_action: operation,
				ids: selected_threads.join('|'),
				silent: 'yes',
				nonce: CommunityAllyLoader.nonce
			};
		$.ajax({
			type: 'POST',
			url: CommunityAllyLoader.ajax_url,
			data: data
		});

		// update frontend display
		for (i in selected_threads) {
			thread_id = selected_threads[i];
			if ('add-star' === operation) {
				$('.communityally-messages-is-starred-' + thread_id).val('yes').change();
			} else if ('remove-star' === operation) {
				$('.communityally-messages-is-starred-' + thread_id).val('no').change();
			} else if ('delete' === operation) {
				$('.communityally-messages-row-' + thread_id).fadeOut();
			} else if ('read' === operation) {
				$('.communityally-messages-row-' + thread_id).removeClass('unread');
			} else if ('unread' === operation) {
				$('.communityally-messages-row-' + thread_id).addClass('unread');
			}
		}

		// reset the checkboxes and operation selection
		$('[communityally-bulk-select-all="' + identifier + '"]').prop('checked', false),
		$checkboxes.prop('checked', false).change();
		$operation_select.val('').change();
		return false;
	}
	$(document).on('click touchend', '[communityall-messages-bulk-submit]', privateMessageSubmitBulkOperation);
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="private message delete thread in reply view">
	function privateMessageDeleteReplyThread() {
		let thread_id = $(this).attr('communityally-messages-delete-reply-thread'),
			conf = confirm(CommunityAllyLoader.messages.DELETE_MESSAGE_WARNING);
		if (!conf) {
			return false;
		}
		let data = {
				action: 'communityally_messages_bulk_action',
				bulk_action: 'delete',
				ids: thread_id,
				silent: 'yes',
				nonce: CommunityAllyLoader.nonce
			};
		$('#communityally-wait-overlay').show();
		$.ajax({
			type: 'POST',
			url: CommunityAllyLoader.ajax_url,
			data: data,
			success: function(response) {
				try {
					var result = JSON.parse(response);
					if ('status' in result) {
						if ('success' === result['status']) {
							window.location.href = result['inbox'];
						} else {
							throw result['message'];
						}
					}
				} catch (e) {
					let $error_elem = $('#communityally-members-messages-error-message');
					$error_elem.find('p').text(e);
					$error_elem.show();
					$('#communityally-wait-overlay').hide();
				}
			}
		});
		return false;
	}
	$(document).on('click touchend', '[communityally-messages-delete-reply-thread]', privateMessageDeleteReplyThread);
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="private message pagination">
	function privateMessagePaginationAction() {
		let $this = $(this),
			$parent = $this.parents('[communityally-members-messages-page-update]'),
			data = {
				action: 'communityally_messages_update_list',
				box: $parent.attr('communityally-members-messages-page-update'),
				page: $this.attr('href'),
				nonce: CommunityAllyLoader.nonce
			};
		if ($parent.length < 1) {
			return;
		}
		update_messages_ajax_call(data);
		return false;
	}
	$(document).on('click touchend', '[communityally-members-messages-page-update] a', privateMessagePaginationAction);
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="Private message search">
	function update_messages_ajax_call(data){
		$('#communityally-wait-overlay').show();
		$.ajax({
			type: 'POST',
			url: CommunityAllyLoader.ajax_url,
			data: data,
			success: function(response) {
				try {
					var result = JSON.parse(response);
					if ('status' in result) {
						if ('success' === result['status']) {
							$('#communityally-members-messages-container').after(result['code']).remove();
						} else {
							throw result['message'];
						}
					}
				} catch (e) {
					let $error_elem = $('#communityally-members-messages-error-message');
					$error_elem.find('p').text(e);
					$error_elem.show();
				}
				$('#communityally-wait-overlay').hide();
			}
		});
	}
	function privateMessageSearch(){
		let $this = $(this),
			values = communityally_serialize_value_in_container($this),
			data = {
				action: 'communityally_messages_update_list',
				input: JSON.stringify(values),
				box: $this.attr('communityally-members-messages-page-update'),
				nonce: CommunityAllyLoader.nonce
			};
		update_messages_ajax_call(data);
		return false;
	}
	$(document).on('submit', 'form[communityally-members-messages-page-update]', privateMessageSearch);
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="Private message click on row to open">
	function messages_click_to_open($elem) {
		let $parent = $elem.parents('[communityally-messages-open]'),
			url = $parent.attr('communityally-messages-open');
		window.location.href = url;
		return false;
	}
	$(document).on('click touchend', '[communityally-messages-open] .communityally-messages-click-to-open-strict', function(e) {
		if (this !== e.target) {
			return;
		}
		messages_click_to_open($(this));
	});
	$(document).on('click touchend', '[communityally-messages-open] .communityally-messages-click-to-open', function(e) {
		messages_click_to_open($(this));
	});
	// </editor-fold>
} )( window.bp, jQuery );
