<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class CommunityAllyMessages {
	public static function activate_messages_component() {
		$active_components = bp_get_option( '_communityally_active_components' );
		if (!isset($active_components['messages'])){
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			require_once( buddypress()->plugin_dir . '/bp-core/admin/bp-core-admin-schema.php' );
			bp_core_install_private_messaging();
			$active_components['messages'] = 1;
			bp_update_option('_communityally_active_components', $active_components);
		}
	}
	public static function deactivate_messages_component() {
		$active_components = bp_get_option( '_communityally_active_components' );
		unset($active_components['messages']);
		bp_update_option('_communityally_active_components', $active_components);
	}
}