<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class CommunityAllyUtilities {
	// <editor-fold defaultstate="collapsed" desc="Replace placeholder with real value when generating setting page">
	public static function recursive_replace_real_values($template, $settings, $root_key, $is_default = false) {
		foreach($settings as $key => $value) {
			if (is_array($value)) {
				$key = $root_key . $key;
				$template = self::recursive_replace_real_values($template, $value, $key . '--', $is_default);
			} else {
				$is_select = false;
				$is_specific_select = false;
				$is_radio_input = false;
				if (0 === strpos($key, 'checked-')) {
					$value = $value === 'yes' ? 'checked="checked"' : '';
				} elseif (0 === strpos($key, 'select-')) {
					$is_specific_select = true;
				} elseif (0 === strpos($key, 'radio-')) {
					$is_radio_input = true;
				} else {
					$value = esc_textarea($value);
				}
				if (!$is_default && $is_select) {
					$option = str_replace('s--selected-'.$value.'--d', 'selected="selected"', $option);
					$value = preg_replace('/s--selected-.*?--d/', '', $option);
				}
				$key = $root_key . $key;
				if ($is_specific_select) {
					if (!$is_default) {
						$template = str_replace('s--' . $key . '--' . $value . '--d', 'selected="selected"', $template);
					}
					$template = preg_replace('/s--' . $key . '--.*?--d/', '', $template);
				} elseif ($is_radio_input) {
					if (!$is_default) {
						$template = str_replace('r--' . $key . '--' . $value . '--o', 'checked="checked"', $template);
					}
					$template = preg_replace('/r--' . $key . '--.*?--o/', '', $template);
				} else {
					$template = str_replace('{{' . $key . '}}', $value, $template);
				}
			}
		}
		return $template;
	}
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="Convert setting string to variable">
	private static function json_name_string_to_keys($name) {
		$a = array();
		$start = strpos($name, '[');
		$end = 0;
		if ($start > 0){
			$a []= substr($name, 0, $start);
		}
		while($start !== false) {
			$start += 1;
			$end = strpos($name, ']', $start);
			if ($end === false) {
				$end = $start;
				break;
			}
			$a []= substr($name, $start, $end - $start);
			$end += 1;	// skip the ']' symbol
			$start = strpos($name, '[', $end);
		}
		if ($end < strlen($name)) {
			$a []= substr($name, $end);
		}
		return $a;
	}
	public static function convert_setting_string_to_array($str) {
		$raw_array = json_decode($str, true);
		$a = array();
		if (!is_array($raw_array)) {
			return false;
		}
		foreach ($raw_array as $tuple) {
			if (isset($tuple['name']) && isset($tuple['value'])) {
				$keys = self::json_name_string_to_keys($tuple['name']);
				$v = & $a;
				for($i = 0; $i < count($keys) - 1; ++$i) {
					if (!array_key_exists($keys[$i], $v)) {
						$v[$keys[$i]] = array();
					}
					$v = & $v[$keys[$i]];
				}
				$last_key = end($keys);
				if (empty($last_key)) {
					$v []= $tuple['value'];
				} else {
					$v[end($keys)] = $tuple['value'];
				}
			}
		}
		return $a;
	}
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="evaluate toggle visibility blocks">
	private static function evaluate_toggle_variable($match_value, $variable_path, $settings, $true_replace, $false_replace) {
		$variable_path = str_replace('[', ',', $variable_path);
		$variable_path = str_replace(']', '', $variable_path);
		$args = explode(',', $variable_path);
		foreach($args as $arg) {
			if ($arg) {
				if (isset($settings[$arg])) {
					$settings = $settings[$arg];
				} else {
					return $false_replace;
				}
			}
		}
		$match_values = explode('|', $match_value);
		if (in_array($settings, $match_values)) {
			return $true_replace;
		}
		return $false_replace;
	}

	private static function replace_specific_toggle($code, $settings, $toggle_name, $true_replace, $false_replace) {
		$matches = array();
		$matches_not = array();
		preg_match_all('/(' . $toggle_name . '="(.*?)")(.*?)communityally-data-dependency-value="(.*?)"/', $code, $matches);
		preg_match_all('/(' . $toggle_name . '="(.*?)")(.*?)communityally-data-dependency-value-not="(.*?)"/', $code, $matches_not);
		
		if (!empty($matches)) {
			$code = self::replace_toggle_values($code, $settings, $toggle_name, $matches, $true_replace, $false_replace);
		}
		if (!empty($matches_not)) {
			$code = self::replace_toggle_values($code, $settings, $toggle_name, $matches_not, $false_replace, $true_replace);
		}
		return $code;
	}
	
	private static function replace_toggle_values($code, $settings, $toggle_name, $toggle_matches, $true_replace, $false_replace) {
		$length = count($toggle_matches[1]);
		for ($i=0;$i<$length;++$i){
			$new_value = self::evaluate_toggle_variable($toggle_matches[4][$i], $toggle_matches[2][$i], $settings, $true_replace, $false_replace);
			$to_replace = $toggle_matches[0][$i];
			$to_replace = str_replace($toggle_matches[1][$i], $toggle_name . $new_value, $to_replace);
			
			$code = str_replace($toggle_matches[0][$i], $to_replace, $code);
		}
		return $code;
	}

	public static function replace_all_toggle($code, $settings) {
		$code = self::replace_specific_toggle($code, $settings, 'hide-toggle', '', ' style="display:none;"');
		$code = self::replace_specific_toggle($code, $settings, 'disable-toggle', '', ' disabled="disabled"');
		$code = self::replace_specific_toggle($code, $settings, 'readonly-toggle', '', ' readonly="readonly"');

		return $code;
	}
	// </editor-fold>
}