<?php

declare(strict_types=1);

namespace CommunityAlly\Tests\TestCases;

use CommunityAlly\Tests\Framework\WPTestCase;

/**
 * A sample test case class.
 */
class TestBpGroupsFunction extends WPTestCase
{
    /**
     * Tests the communityally_update_group_permission function updates the group meta correctly.
     */
    public function test_communityally_update_group_permission()
    {
        $group_id = 1;
        $initial_group_meta = array(
            'required-tag-ids' => array(1, 2, 3),
            'forbidden-tag-ids' => array(4, 5, 6),
        );
        communityally_update_group_permission($group_id, $initial_group_meta);

        $this->assertFalse(
            communityally_can_user_join_group(array( 7 ), $this->mock_group_meta_object($group_id))
        );
       
        /** After updating the group meta, the user should be able to join the group */
        $permission_param = array(
            'required-tag-ids' => array(1, 2, 3, 7),
            'forbidden-tag-ids' => array(4, 5, 6),
        );

        communityally_update_group_permission($group_id, $permission_param);

        $this->assertTrue(
            communityally_can_user_join_group(array( 7 ), $this->mock_group_meta_object($group_id))
        );
    }

    private function mock_group_meta_object($group_id) {
        $group_meta = groups_get_groupmeta($group_id, META_KEY_COMMUNITY_ALLY_GROUP_PERMISSION, true);
        $meta_object = new \stdClass();
        $meta_object->meta_value = serialize($group_meta);
        return $meta_object;
    }
}
