<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use WP_UnitTest_Factory_For_Thing;
use WP_UnitTest_Generator_Sequence;

class AuthorizeWebhookFactory extends WP_UnitTest_Factory_For_Thing
{
    /**
     * Request JSON.
     *
     * @var string
     */
    public $request_json;

    /**
     * Transaction details as a JSON string.
     *
     * @var string
     */
    public $transaction_details;

    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'eventType'    => 'net.authorize.payment.authcapture.created',
            'responseCode' => 1,
            'authAmount'   => 1.00,
            'settleAmount' => 1.00,
            'entityName'   => 'transaction',
            'transId'      => new WP_UnitTest_Generator_Sequence('%s'),
            'subId'        => new WP_UnitTest_Generator_Sequence('%s'),
            'cardNumber'   => 'XXXX1111',
        ];
    }

    /**
     * Creates a new Authorize Webhook object.
     *
     * @param array $args Creation arguments array.
     */
    public function create_object($args)
    {
        $webhook                      = new AuthorizeWebhookFactory($args);
        $webhook->request_json        = json_encode([
            'eventType' => $webhook->factory['eventType'],
            'payload'   => [
                'responseCode' => $webhook->factory['responseCode'],
                'id'           => $webhook->factory['transId'],
            ],
        ]);
        $webhook->transaction_details = json_encode([
            'transaction' => [
                'transId'      => $webhook->factory['transId'],
                'subscription' => [
                    'id' => $webhook->factory['subId'],
                ],
                'settleAmount' => $webhook->factory['settleAmount'],
                'payment'      => [
                    'creditCard' => [
                        'cardNumber' => $webhook->factory['cardNumber'],
                    ],
                ],
            ],
        ]);

        return $webhook;
    }

    /**
     * Updates an object.
     *
     * @param integer $id     The object ID.
     * @param array   $fields Field data to update.
     */
    public function update_object($id, $fields)
    {
    }

    /**
     * Retrieves the object by ID.
     *
     * @param integer $id The object ID.
     */
    public function get_object_by_id($id)
    {
    }
}
