<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use MeprGroup;
use WP_UnitTest_Factory_For_Post;
use WP_UnitTest_Generator_Sequence;

class GroupFactory extends WP_UnitTest_Factory_For_Post
{
    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'post_title' => new WP_UnitTest_Generator_Sequence('Test Group %s'),
            'post_type'  => MeprGroup::$cpt,
        ];
    }

    /**
     * Creates a new object.
     *
     * @param  array $args Array of coupon creation arguments.
     * @return integer
     */
    public function create_object($args)
    {
        $post_id = wp_insert_post($args);
        $group   = new MeprGroup($post_id);
        foreach ($args as $key => $value) {
            $group->$key = $value;
        }
        $group->store_meta();
        return $group->ID;
    }

    /**
     * Updates an object.
     *
     * @param  integer $id     The object ID.
     * @param  array   $fields Field data to update.
     * @return integer
     */
    public function update_object($id, $fields)
    {
        $group = new MeprGroup($id);
        foreach ($fields as $key => $value) {
            $group->$key = $value;
        }

        $group->store_meta();
        return $group->ID;
    }

    /**
     * Retrieves the object by ID.
     *
     * @param  integer $id The object ID.
     * @return MeprGroup
     */
    public function get_object_by_id($id)
    {
        return new MeprGroup($id);
    }
}
