<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use MeprRuleAccessCondition;
use WP_UnitTest_Factory_For_Thing;
use WP_UnitTest_Generator_Sequence;

class RuleAccessConditionFactory extends WP_UnitTest_Factory_For_Thing
{
    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'rule_id'          => new WP_UnitTest_Generator_Sequence('%s'),
            'access_type'      => 'membership',
            'access_operator'  => 'is',
            'access_condition' => new WP_UnitTest_Generator_Sequence('%s'),
        ];
    }

    /**
     * Creates a new object.
     *
     * @param  array $args Array of coupon creation arguments.
     * @return integer
     */
    public function create_object($args)
    {
        $rule_access_condition = new MeprRuleAccessCondition($args);
        $rule_access_condition->store();
        return $rule_access_condition->id;
    }

    /**
     * Updates an object.
     *
     * @param  integer $id     The object ID.
     * @param  array   $fields Field data to update.
     * @return integer
     */
    public function update_object($id, $fields)
    {
        $rule_access_condition = new MeprRuleAccessCondition($id);
        foreach ($fields as $key => $value) {
            $rule_access_condition->$key = $value;
        }

        MeprRuleAccessCondition::update($rule_access_condition);
        return $rule_access_condition;
    }

    /**
     * Retrieves the object by ID.
     *
     * @param  integer $id The object ID.
     * @return MeprRuleAccessCondition
     */
    public function get_object_by_id($id)
    {
        return new MeprRuleAccessCondition($id);
    }
}
