<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use MeprSubscription;
use MeprUtils;
use WP_UnitTest_Factory_For_Thing;

class SubscriptionFactory extends WP_UnitTest_Factory_For_Thing
{
    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'price'      => 1.01,
            'status'     => MeprSubscription::$active_str,
            'total'      => 1.01,
            'created_at' => MeprUtils::ts_to_mysql_date(time()),
        ];
    }

    /**
     * Creates a new object.
     *
     * @param  array $args Array of coupon creation arguments.
     * @return integer
     */
    public function create_object($args)
    {
        $subscription = new MeprSubscription($args);
        $subscription->store();
        return $subscription->id;
    }

    /**
     * Updates an object.
     *
     * @param  integer $id     The object ID.
     * @param  array   $fields Field data to update.
     * @return integer
     */
    public function update_object($id, $fields)
    {
        $subscription = new MeprSubscription($id);
        foreach ($fields as $key => $value) {
            $subscription->$key = $value;
        }

        MeprSubscription::update($subscription);
        return $subscription;
    }

    /**
     * Retrieves the object by ID.
     *
     * @param  integer $id The object ID.
     * @return MeprSubscription
     */
    public function get_object_by_id($id)
    {
        return new MeprSubscription($id);
    }
}
