<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use MeprTransaction;
use MeprUtils;
use WP_UnitTest_Factory_For_Thing;

class TransactionFactory extends WP_UnitTest_Factory_For_Thing
{
    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'user_id'    => $this->factory->user->create(),
            'status'     => MeprTransaction::$complete_str,
            'amount'     => 1.01,
            'created_at' => MeprUtils::ts_to_mysql_date(time()),
        ];
    }

    /**
     * Creates a new object.
     *
     * @param  array $args Array of coupon creation arguments.
     * @return integer
     */
    public function create_object($args)
    {
        $transaction = new MeprTransaction($args);
        $transaction->store();
        return $transaction->id;
    }

    /**
     * Updates an object.
     *
     * @param integer $id     The object ID.
     * @param array   $fields Field data to update.
     */
    public function update_object($id, $fields)
    {
    }

    /**
     * Retrieves the object by ID.
     *
     * @param  integer $id The object ID.
     * @return MeprTransaction
     */
    public function get_object_by_id($id)
    {
        return new MeprTransaction($id);
    }
}
