<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories\MemberPress;

use MeprUser;
use WP_UnitTest_Factory_For_Thing;
use WP_UnitTest_Generator_Sequence;

class UserFactory extends WP_UnitTest_Factory_For_Thing
{
    /**
     * Constructor
     *
     * @param object|null $factory Optional factory object.
     */
    public function __construct($factory = null)
    {
        parent::__construct($factory);
        $this->default_generation_definitions = [
            'user_login' => new WP_UnitTest_Generator_Sequence('meprtest%s'),
            'user_pass'  => 'pass',
        ];
    }

    /**
     * Creates a new user object.
     *
     * @param  array $args User creation data.
     * @return integer The created user's ID.
     */
    public function create_object($args)
    {
        $user             = new MeprUser();
        $user->user_login = $args['user_login'];
        $user->set_password($args['user_pass']);
        $user->store();
        return $user->ID;
    }

    /**
     * Updates the user object.
     *
     * @param MeprUser $object User object.
     * @param array    $fields Data to update.
     */
    public function update_object($object, $fields)
    {
    }

    /**
     * Retrieves a user by ID.
     *
     * @param  integer $id The user's ID.
     * @return MeprUser
     */
    public function get_object_by_id($id)
    {
        return new MeprUser($id);
    }
}
