<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Factories;

use WP_UnitTest_Factory;
use GroundLevel\Testing\Factories\MemberPress\SubscriptionFactory;
use GroundLevel\Testing\Factories\MemberPress\TransactionFactory;
use GroundLevel\Testing\Factories\MemberPress\UserFactory;
use GroundLevel\Testing\Factories\MemberPress\GroupFactory;
use GroundLevel\Testing\Factories\MemberPress\ProductFactory;
use GroundLevel\Testing\Factories\MemberPress\CouponFactory;
use GroundLevel\Testing\Factories\MemberPress\AuthorizeWebhookFactory;
use GroundLevel\Testing\Factories\MemberPress\RuleFactory;
use GroundLevel\Testing\Factories\MemberPress\RuleAccessConditionFactory;

/**
 * Base Caesproof tests unit test factory.
 *
 * Extends the default WordPress unit test factory and adds factories for various
 * MemberPress objects.
 */
class UnitTestFactory extends WP_UnitTest_Factory
{
    /**
     * Factory for AuthorizeWebhooks.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\AuthorizeWebhookFactory
     */
    public $authorize_webhook;

    /**
     * Factory for Coupons.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\CouponFactory
     */
    public $coupon;

    /**
     * Factory for Groups.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\GroupFactory
     */
    public $group;

    /**
     * Factory for Products.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\ProductFactory
     */
    public $product;

    /**
     * Factory for Rules.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\RuleFactory
     */
    public $rule;

    /**
     * Factory for Rule Access Conditions.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\RuleAccessConditionFactory
     */
    public $rule_access_condition;

    /**
     * Factory for subscriptions.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\SubscriptionFactory
     */
    public $subscription;

    /**
     * Factory for transactions.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\TransactionFactory
     */
    public $transaction;

    /**
     * Factory for users.
     *
     * @var \GroundLevel\Testing\Factories\MemberPress\UserFactory
     */
    public $user;

    /**
     * Constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->authorize_webhook     = new AuthorizeWebhookFactory($this);
        $this->coupon                = new CouponFactory($this);
        $this->group                 = new GroupFactory($this);
        $this->product               = new ProductFactory($this);
        $this->rule                  = new RuleFactory($this);
        $this->rule_access_condition = new RuleAccessConditionFactory($this);
        $this->subscription          = new SubscriptionFactory($this);
        $this->transaction           = new TransactionFactory($this);
        $this->user                  = new UserFactory($this);
    }
}
