<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Traits;

use Faker\Factory;
use Faker\Generator;

/**
 * Provides access to the Faker data generator.
 *
 * @link https://fakerphp.github.io/
 *
 * Example:
 * ```php
 *   public function testSomething(): void
 *   {
 *      $fakeName = $this->faker()->name();
 *      // Test something...
 *   }
 */
trait FakesData
{
    /**
     * Faker generator instance.
     *
     * @var \Faker\Generator
     */
    protected static $faker;

    /**
     * Provides access to the faker generator instance.
     *
     * @return \Faker\Generator
     */
    protected static function faker(): Generator
    {
        if (! isset(self::$faker)) {
            self::$faker = Factory::create();
        }
        return self::$faker;
    }
}
