<?php

declare(strict_types=1);

namespace GroundLevel\Testing\Traits;

use ReflectionClass;
use ReflectionProperty;

/**
 * Class trait with utility functions for reading private/protected properties.
 */
trait ReadsProperties
{
    /**
     * Retrieves a private or protected property of an object.
     *
     * @param  string|object $object       An instance of the class or the class name.
     * @param  string        $propertyName The name of property to retrieve.
     * @return ReflectionProperty
     */
    public function getProperty($object, string $propertyName): ReflectionProperty
    {
        $reflect  = new ReflectionClass($object);
        $property = $reflect->getProperty($propertyName);
        $property->setAccessible(true);
        return $property;
    }

    /**
     * Retrieves the current value of a private or protected property of an object.
     *
     * @param  string|object $object       An instance of the class or the class name.
     * @param  string        $propertyName The name of property for which to retrieve the value.
     * @return mixed
     */
    public function getPropertyValue($object, string $propertyName)
    {
        $property = $this->getProperty($object, $propertyName);
        return $property->isStatic() ? $property->getValue() : $property->getValue($object);
    }
}
